/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jppf.io.AbstractDataLocation;
import org.jppf.io.DataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.OutputDestination;

public class FileLocation
extends AbstractDataLocation {
    private int count = 0;
    private FileChannel fileChannel = null;
    private String filePath = null;
    private ByteBuffer buffer = null;
    private int blockSize = 0;
    private int blockCount = 0;

    public FileLocation(String path, int size) {
        this.filePath = path;
        this.size = size;
    }

    public FileLocation(File file, int size) {
        this.filePath = file.getPath();
        this.size = size;
    }

    public int transferFrom(InputSource source, boolean blocking) throws Exception {
        if (!this.transferring) {
            this.transferring = true;
            this.fileChannel = new FileOutputStream(this.filePath).getChannel();
            this.buffer = ByteBuffer.wrap(new byte[32768]);
            if (this.size < this.buffer.limit()) {
                this.buffer.limit(this.size);
            }
            this.count = 0;
        }
        try {
            int n;
            int n2 = n = blocking ? this.blockingTransferFrom(source) : this.nonBlockingTransferFrom(source);
            if (n < 0 || this.count >= this.size) {
                this.transferring = false;
            }
            int n3 = n;
            return n3;
        }
        catch (Exception e) {
            this.transferring = false;
            throw e;
        }
        finally {
            if (!this.transferring) {
                this.buffer = null;
                if (this.fileChannel != null) {
                    this.fileChannel.force(false);
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
            }
        }
    }

    private int nonBlockingTransferFrom(InputSource source) throws Exception {
        int n = source.read(this.buffer);
        if (n > 0) {
            int remaining = this.size - this.count;
            if (remaining < this.buffer.limit() && remaining > 0) {
                this.buffer.limit(remaining);
            }
            this.count += n;
            this.buffer.flip();
            int tempCount = 0;
            while (tempCount < n) {
                int tmp = this.fileChannel.write(this.buffer);
                if (tmp < 0) {
                    this.transferring = false;
                    return -1;
                }
                tempCount += tmp;
            }
            this.buffer.clear();
        }
        if (n < 0 || this.count >= this.size) {
            this.transferring = false;
        }
        return n;
    }

    private int blockingTransferFrom(InputSource source) throws Exception {
        while (this.count < this.size) {
            int n;
            int remaining = this.size - this.count;
            if (remaining < this.buffer.limit() && remaining > 0) {
                this.buffer.limit(remaining);
            }
            if ((n = source.read(this.buffer)) < 0) {
                this.transferring = false;
                return -1;
            }
            if (n <= 0) continue;
            this.count += n;
            this.buffer.flip();
            int tempCount = 0;
            while (tempCount < n) {
                int tmp = this.fileChannel.write(this.buffer);
                if (tmp < 0) {
                    this.transferring = false;
                    return -1;
                }
                tempCount += tmp;
            }
            this.buffer.clear();
        }
        this.transferring = false;
        return this.count;
    }

    public int transferTo(OutputDestination dest, boolean blocking) throws Exception {
        if (!this.transferring) {
            this.transferring = true;
            this.fileChannel = new FileInputStream(this.filePath).getChannel();
            this.buffer = ByteBuffer.wrap(new byte[32768]);
            this.count = 0;
        }
        try {
            int n = blocking ? this.blockingTransferTo(dest) : this.nonBlockingTransferTo(dest);
            return n;
        }
        catch (Exception e) {
            this.transferring = false;
            throw e;
        }
        finally {
            if (!this.transferring) {
                this.buffer = null;
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
            }
        }
    }

    private int nonBlockingTransferTo(OutputDestination dest) throws Exception {
        int n;
        if (this.blockSize == 0) {
            this.blockSize = this.fileChannel.read(this.buffer);
            this.buffer.flip();
        }
        if ((n = dest.write(this.buffer)) < 0) {
            this.transferring = false;
            return -1;
        }
        this.blockCount += n;
        if (!this.buffer.hasRemaining()) {
            this.count += this.blockSize;
            this.blockSize = 0;
            this.buffer.clear();
            if (this.count >= this.size) {
                this.transferring = false;
            }
        }
        return n;
    }

    private int blockingTransferTo(OutputDestination dest) throws Exception {
        while (this.count < this.size) {
            this.blockSize = this.fileChannel.read(this.buffer);
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                int n = dest.write(this.buffer);
                if (n < 0) {
                    this.transferring = false;
                    return -1;
                }
                this.count += n;
            }
            if (this.count >= this.size) continue;
            this.buffer.clear();
        }
        this.transferring = false;
        return this.count;
    }

    protected void finalize() throws Throwable {
        File file = new File(this.filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    public InputStream getInputStream() throws Exception {
        return new BufferedInputStream(new FileInputStream(this.filePath));
    }

    public OutputStream getOutputStream() throws Exception {
        return new BufferedOutputStream(new FileOutputStream(this.filePath));
    }

    public DataLocation copy() {
        return new FileLocation(this.filePath, this.size);
    }
}

