/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.File;
import org.jppf.io.ByteBufferLocation;
import org.jppf.io.DataLocation;
import org.jppf.io.FileLocation;
import org.jppf.io.InputSource;
import org.jppf.utils.SystemUtils;

public final class IOHelper {
    public static final int TEMP_BUFFER_SIZE = 32768;

    private IOHelper() {
    }

    public static DataLocation createDataLocationMemorySensitive(int size) throws Exception {
        return IOHelper.createDataLocationMemorySensitive(size, size);
    }

    public static DataLocation createDataLocationMemorySensitive(int size, int memorySize) throws Exception {
        long freeMem = SystemUtils.maxFreeHeap();
        if ((long)(1.2 * (double)memorySize) < freeMem) {
            return new ByteBufferLocation(size);
        }
        File file = File.createTempFile("jppf", ".tmp");
        file.deleteOnExit();
        return new FileLocation(file, size);
    }

    public static DataLocation readData(InputSource source) throws Exception {
        int n = source.readInt();
        DataLocation dl = IOHelper.createDataLocationMemorySensitive(n);
        dl.transferFrom(source, true);
        return dl;
    }

    public static DataLocation readData(InputSource source, int memorySize) throws Exception {
        int n = source.readInt();
        DataLocation dl = IOHelper.createDataLocationMemorySensitive(n, memorySize);
        dl.transferFrom(source, true);
        return dl;
    }
}

