/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.io.OutputDestination;

public class SocketWrapperOutputDestination
implements OutputDestination {
    private SocketWrapper socketWrapper = null;

    public SocketWrapperOutputDestination(SocketWrapper socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    public int write(byte[] data, int offset, int len) throws Exception {
        this.socketWrapper.write(data, offset, len);
        return len;
    }

    public int write(ByteBuffer data) throws Exception {
        ByteBuffer tmp = ByteBuffer.wrap(new byte[32768]);
        byte[] buf = tmp.array();
        int size = Math.min(buf.length, data.remaining());
        data.get(buf, 0, size);
        this.socketWrapper.write(buf, 0, size);
        return size;
    }

    public void writeInt(int value) throws Exception {
        this.socketWrapper.writeInt(value);
    }

    public void close() throws IOException {
    }
}

