/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.libmanagement;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jppf.server.protocol.FileLocation;
import org.jppf.server.protocol.LocationEvent;
import org.jppf.server.protocol.LocationEventListener;
import org.jppf.server.protocol.URLLocation;
import org.jppf.utils.FileUtils;

public class Downloader {
    private LocationEventListener listener = null;

    public static void main(String ... args) {
        try {
            Downloader donwloader = new Downloader();
            donwloader.extractFiles("http://downloads.sourceforge.net/jfreechart/jfreechart-1.0.12.zip", "lib", "jfreechart-1.0.12.jar", "jcommon-1.0.15.jar");
            System.out.println("done");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void extractFiles(String sourceUrl, String destPath, String ... names) throws Exception {
        File tmp = null;
        try {
            File dir = new File(destPath);
            if (this.checkFilesPresent(dir, names)) {
                System.out.println("The files are already present in the destination folder");
                return;
            }
            URLLocation source = new URLLocation(sourceUrl);
            tmp = File.createTempFile("jppf_", ".tmp");
            FileLocation dest = new FileLocation(tmp);
            System.out.println("downloading " + source);
            LocationEventListener l = this.listener;
            if (l == null) {
                l = new LocationEventListener(){
                    private int count = 0;

                    public void dataTransferred(LocationEvent event) {
                        int p;
                        int oneMB = 0x100000;
                        int n = event.bytesTransferred();
                        if (n + (p = this.count % oneMB) >= oneMB) {
                            System.out.println((n + this.count) / oneMB + " MB downloaded");
                        }
                        this.count += n;
                    }
                };
            }
            source.addLocationEventListener(l);
            source.copyTo(dest);
            System.out.println("downloaded to " + dest);
            ZipFile zip = new ZipFile(tmp);
            dir.mkdirs();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ZipEntry entry = zip.getEntry("jfreechart-1.0.12/lib/" + name);
                InputStream is = zip.getInputStream(entry);
                File f = new File("lib/" + name);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                FileUtils.copyStream((InputStream)is, (OutputStream)os);
                is.close();
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
                System.out.println("extracted " + entry.getName() + " to " + f);
                ++n2;
            }
            source.removeLocationEventListener(l);
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public boolean checkFilesPresent(File folder, String ... names) {
        File[] files;
        if (!folder.exists() || !folder.isDirectory()) {
            return false;
        }
        File[] fileArray = files = FileUtils.toFiles((File)folder, (String[])names);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.exists()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public LocationEventListener getListener() {
        return this.listener;
    }

    public void setListener(LocationEventListener listener) {
        this.listener = listener;
    }

    private static class URLToFiles {
        public String url = null;
        public String[] files = null;
        public String dir = null;

        private URLToFiles() {
        }
    }
}

