/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.imageio.spi.ServiceRegistry;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.management.spi.JPPFMBeanProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFMBeanProviderManager<S extends JPPFMBeanProvider> {
    private static Log log = LogFactory.getLog(JPPFMBeanProviderManager.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Class<S> providerClass = null;
    private List<S> providerList = null;
    private List<String> registeredMBeanNames = new Vector<String>();
    private MBeanServer server = null;

    public JPPFMBeanProviderManager(Class<S> clazz, MBeanServer server) {
        this.providerClass = clazz;
        this.server = server;
    }

    public List<S> getAllProviders() {
        if (this.providerList == null) {
            this.providerList = new ArrayList<S>();
            Iterator<S> it = ServiceRegistry.lookupProviders(this.providerClass);
            while (it.hasNext()) {
                this.providerList.add((JPPFMBeanProvider)it.next());
            }
        }
        return this.providerList;
    }

    public <T> boolean registerProviderMBean(T impl, Class<T> intf, String name) {
        try {
            if (debugEnabled) {
                log.debug((Object)("found MBean provider: [name=" + name + ", inf=" + intf + ", impl=" + impl.getClass().getName() + "]"));
            }
            this.server.registerMBean(impl, new ObjectName(name));
            this.registeredMBeanNames.add(name);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void unregisterProviderMBeans() {
        while (!this.registeredMBeanNames.isEmpty()) {
            String s = this.registeredMBeanNames.remove(0);
            try {
                this.server.unregisterMBean(new ObjectName(s));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

