/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.scheduling;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JPPFSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long duration = 0L;
    private String date = null;
    private String format = null;
    private transient SimpleDateFormat dateFormat = null;

    public JPPFSchedule(long duration) {
        this.duration = duration;
    }

    public JPPFSchedule(String date, String format) {
        this.date = date;
        this.format = format;
    }

    public JPPFSchedule(String date, SimpleDateFormat dateFormat) {
        this.date = date;
        this.format = dateFormat.toPattern();
    }

    public long getDuration() {
        return this.duration;
    }

    public String getDate() {
        return this.date;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public Date toDate(long startDate) throws ParseException {
        Date dt = null;
        if (this.date == null || this.format == null) {
            dt = new Date(startDate + this.duration);
        } else {
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat(this.format);
            }
            dt = this.dateFormat.parse(this.date);
        }
        return dt;
    }

    public long toLong(long startDate) throws ParseException {
        long result = 0L;
        if (this.date == null || this.format == null) {
            result = startDate + this.duration;
        } else {
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat(this.format);
            }
            Date dt = this.dateFormat.parse(this.date);
            result = dt.getTime();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("schedule[");
        if (this.dateFormat == null && this.format != null) {
            this.dateFormat = new SimpleDateFormat(this.format);
        }
        if (this.date != null) {
            sb.append("date=").append(this.date).append(", format=").append(this.dateFormat == null ? "null" : this.dateFormat.toPattern());
        } else {
            sb.append("delay=").append(this.duration);
        }
        sb.append("]");
        return sb.toString();
    }
}

