/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.scheduling;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.scheduling.JPPFSchedule;

public class JPPFScheduleHandler {
    private static Log log = LogFactory.getLog(JPPFScheduleHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Timer timer = null;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private Map<Object, TimerTask> timerTaskMap = new Hashtable<Object, TimerTask>();
    private String name = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public JPPFScheduleHandler() {
        this("JPPFScheduleHandler timer - " + instanceCount.incrementAndGet());
    }

    public JPPFScheduleHandler(String name) {
        this.name = name;
        this.timer = new Timer(name);
    }

    public void scheduleAction(Object key, JPPFSchedule schedule, Runnable action) throws ParseException {
        this.scheduleAction(key, schedule, action, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAction(Object key, JPPFSchedule schedule, Runnable action, long start) throws ParseException {
        if (debugEnabled) {
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                log.debug((Object)(String.valueOf(this.name) + " : scheduling action[key=" + key + ", " + schedule + ", action=" + action + ", start=" + this.sdf.format(new Date(start))));
            }
        }
        Date date = schedule.toDate(start);
        ScheduleHandlerTask task = new ScheduleHandlerTask(key, action);
        this.timerTaskMap.put(key, task);
        if (debugEnabled) {
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                log.debug((Object)(String.valueOf(this.name) + " : date=" + this.sdf.format(date) + ", key=" + key + ", timerTaskMap=" + this.timerTaskMap));
            }
        }
        this.timer.schedule((TimerTask)task, date);
    }

    public void cancelAction(Object key) {
        if (key == null) {
            return;
        }
        TimerTask task = null;
        task = this.timerTaskMap.remove(key);
        if (debugEnabled) {
            log.debug((Object)(String.valueOf(this.name) + " : cancelling action for key=" + key + ", task=" + task));
        }
        if (task != null) {
            task.cancel();
        }
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean shutdown) {
        this.timer.cancel();
        this.timer.purge();
        this.timerTaskMap.clear();
        if (!shutdown) {
            this.timer = new Timer(this.name);
        }
    }

    public class ScheduleHandlerTask
    extends TimerTask {
        private Runnable action = null;
        private Object key = null;

        public ScheduleHandlerTask(Object key, Runnable action) {
            this.key = key;
            this.action = action;
        }

        public void run() {
            JPPFScheduleHandler.this.timerTaskMap.remove(this.key);
            this.action.run();
        }
    }
}

