/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.comm.socket.SocketChannelClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.server.nio.NioServer;

public abstract class AbstractSocketChannelHandler {
    private static Log log = LogFactory.getLog(AbstractSocketChannelHandler.class);
    private boolean debugEnabled = log.isDebugEnabled();
    protected NioServer server = null;
    protected String host = null;
    protected int port = -1;
    protected SocketChannelClient socketClient = null;
    protected SocketInitializer socketInitializer = new SocketInitializerImpl();

    public AbstractSocketChannelHandler(NioServer server) {
        this.server = server;
    }

    public AbstractSocketChannelHandler(NioServer server, String host, int port) {
        this(server);
        this.host = host;
        this.port = port;
    }

    public synchronized void init() throws Exception {
        if (this.socketClient == null) {
            this.socketClient = this.initSocketChannel();
        }
        if (this.debugEnabled) {
            log.debug((Object)("Attempting connection to the remote host [" + this.host + ":" + this.port + "]"));
        }
        this.socketInitializer.initializeSocket((SocketWrapper)this.socketClient);
        if (this.debugEnabled) {
            log.debug((Object)("Connected to the remote host [" + this.host + ":" + this.port + "]"));
        }
        this.postInit();
    }

    protected abstract void postInit() throws Exception;

    protected abstract SocketChannelClient initSocketChannel() throws Exception;

    public SocketChannelClient getSocketClient() {
        return this.socketClient;
    }
}

