/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.NioMessage;
import org.jppf.utils.SerializationUtils;
import org.jppf.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NioContext<S extends Enum> {
    protected static Log log = LogFactory.getLog(NioContext.class);
    protected static boolean debugEnabled = log.isDebugEnabled();
    protected S state = null;
    protected NioMessage message = null;
    protected int readByteCount = 0;
    protected int writeByteCount = 0;
    protected String uuid = null;

    public S getState() {
        return this.state;
    }

    public void setState(S state) {
        this.state = state;
    }

    public boolean readMessage(ReadableByteChannel channel) throws IOException {
        if (this.message == null) {
            this.message = new NioMessage();
        }
        if (this.message.length <= 0) {
            this.message.length = SerializationUtils.readInt((ReadableByteChannel)channel);
            this.message.buffer = ByteBuffer.allocate(this.message.length);
            this.readByteCount = 0;
        }
        this.readByteCount += channel.read(this.message.buffer);
        if (debugEnabled) {
            log.debug((Object)("[" + this.getShortClassName() + "] " + "read " + this.readByteCount + " bytes out of " + this.message.length + " for " + StringUtils.getRemoteHost((Channel)((SocketChannel)channel))));
        }
        return this.readByteCount >= this.message.length;
    }

    public boolean writeMessage(WritableByteChannel channel) throws IOException {
        if (!this.message.lengthWritten) {
            SerializationUtils.writeInt((WritableByteChannel)channel, (int)this.message.length);
            this.message.lengthWritten = true;
            this.writeByteCount = 0;
        }
        this.writeByteCount += channel.write(this.message.buffer);
        if (debugEnabled) {
            log.debug((Object)("[" + this.getShortClassName() + "] " + "written " + this.writeByteCount + " bytes out of " + this.message.length + " for " + StringUtils.getRemoteHost((Channel)((SelectableChannel)((Object)channel)))));
        }
        return this.writeByteCount >= this.message.length;
    }

    public NioMessage getMessage() {
        return this.message;
    }

    public void setMessage(NioMessage message) {
        this.message = message;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    protected String getShortClassName() {
        String fqn = this.getClass().getName();
        int idx = fqn.lastIndexOf(".");
        return fqn.substring(idx + 1);
    }

    public abstract void handleException(SocketChannel var1);
}

