/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.io.ByteBufferLocation;
import org.jppf.io.DataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.OutputDestination;

public class NioObject {
    private static Log log = LogFactory.getLog(NioObject.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private int size = 0;
    private int count = 0;
    private DataLocation data = null;
    private boolean blocking = false;
    private long sessionId = 0L;

    public NioObject(int size, boolean blocking) {
        this(new ByteBufferLocation(size), blocking);
    }

    public NioObject(int size, boolean blocking, long sessionId) {
        this(new ByteBufferLocation(size), blocking, sessionId);
    }

    public NioObject(byte[] data, int offset, int len, boolean blocking) {
        this(new ByteBufferLocation(data, offset, len), blocking);
    }

    public NioObject(DataLocation data, boolean blocking) {
        this.size = data.getSize();
        this.data = data;
        if (data instanceof ByteBufferLocation) {
            ((ByteBufferLocation)data).buffer().rewind();
        }
    }

    public NioObject(DataLocation data, boolean blocking, long sessionId) {
        this.size = data.getSize();
        this.data = data;
        this.sessionId = sessionId;
        if (data instanceof ByteBufferLocation) {
            ((ByteBufferLocation)data).buffer().rewind();
        }
    }

    public boolean read(InputSource source) throws Exception {
        if (this.count >= this.size) {
            return true;
        }
        int n = this.data.transferFrom(source, this.blocking);
        if (n > 0) {
            this.count += n;
        }
        if (this.count >= this.size) {
            if (this.data instanceof ByteBufferLocation) {
                ((ByteBufferLocation)this.data).buffer().flip();
            }
            return true;
        }
        return false;
    }

    public boolean write(OutputDestination dest) throws Exception {
        if (this.count >= this.size) {
            return true;
        }
        int n = this.data.transferTo(dest, this.blocking);
        if (n > 0) {
            this.count += n;
        }
        if (debugEnabled) {
            log.debug((Object)("sessionId = " + this.sessionId + " : wrote " + n + " bytes to output destination, count = " + this.count));
        }
        if (this.count >= this.size) {
            if (debugEnabled) {
                log.debug((Object)("sessionId = " + this.sessionId + " : count = " + this.count + ", size = " + this.size));
            }
            if (this.data instanceof ByteBufferLocation) {
                ((ByteBufferLocation)this.data).buffer().flip();
            }
            return true;
        }
        return false;
    }

    public DataLocation getData() {
        return this.data;
    }

    public int getCount() {
        return this.count;
    }
}

