/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.util.Map;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioState;
import org.jppf.server.nio.NioTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NioServerFactory<S extends Enum<S>, T extends Enum<T>> {
    public static final int RW = 5;
    public static final int R = 1;
    public static final int W = 4;
    protected Map<S, NioState<T>> stateMap = null;
    protected Map<T, NioTransition<S>> transitionMap = null;
    protected NioServer<S, T> server = null;

    protected NioServerFactory(NioServer<S, T> server) {
        this.server = server;
        this.stateMap = this.createStateMap();
        this.transitionMap = this.createTransitionMap();
    }

    public abstract Map<S, NioState<T>> createStateMap();

    public abstract Map<T, NioTransition<S>> createTransitionMap();

    public NioState<T> getState(S name) {
        return this.stateMap.get(name);
    }

    public NioTransition<S> getTransition(T name) {
        return this.transitionMap.get(name);
    }

    public NioServer<S, T> getServer() {
        return this.server;
    }
}

