/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioTransition;
import org.jppf.server.nio.StateTransitionTask;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFThreadFactory;
import org.jppf.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateTransitionManager<S extends Enum<S>, T extends Enum<T>> {
    private static Log log = LogFactory.getLog(StateTransitionManager.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static Object DUMMY_OBJECT = "dummy object";
    protected ExecutorService executor = null;
    private NioServer<S, T> server = null;
    private boolean sequential = false;
    private Lock lock = new ReentrantLock();
    private Set<SelectionKey> processingKeys = new HashSet<SelectionKey>();

    public StateTransitionManager(NioServer<S, T> server, boolean sequential) {
        this.server = server;
        this.sequential = sequential;
        int size = JPPFConfiguration.getProperties().getInt("transition.thread.pool.size", -1);
        if (size <= 0) {
            size = Runtime.getRuntime().availableProcessors();
        }
        if (!sequential) {
            this.executor = Executors.newFixedThreadPool(size, (ThreadFactory)new JPPFThreadFactory(server.getName()));
        }
    }

    protected void submitTransition(SelectionKey key) {
        this.setKeyOps(key, 0);
        StateTransitionTask transition = new StateTransitionTask(key, this.server.getFactory());
        if (this.sequential) {
            transition.run();
        } else {
            this.executor.submit(transition);
        }
    }

    void addKey(SelectionKey key) {
        this.lock.lock();
        try {
            if (!this.processingKeys.contains(key)) {
                this.processingKeys.add(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void releaseKey(SelectionKey key) {
        this.lock.lock();
        try {
            this.processingKeys.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isProcessingKey(SelectionKey key) {
        this.lock.lock();
        try {
            boolean bl = this.processingKeys.contains(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<SelectionKey> getProcessingKeys() {
        this.lock.lock();
        try {
            Set<SelectionKey> set = Collections.unmodifiableSet(this.processingKeys);
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setKeyOps(SelectionKey key, int ops) {
        this.server.getLock().lock();
        try {
            this.server.getSelector().wakeup();
            key.interestOps(ops);
        }
        finally {
            this.server.getLock().unlock();
        }
    }

    public void transitionChannel(SelectionKey key, T transition) {
        this.server.getLock().lock();
        try {
            this.setKeyOps(key, 0);
            NioContext context = (NioContext)key.attachment();
            Object s1 = context.getState();
            NioTransition t = this.server.getFactory().getTransition(transition);
            Object s2 = t.getState();
            if (debugEnabled && !((Enum)s2).equals(s1)) {
                log.debug((Object)(String.valueOf(StringUtils.getRemoteHost((Channel)key.channel())) + " transition from " + (s1 == null ? "NULL" : s1) + " to " + s2));
            }
            context.setState(s2);
            this.setKeyOps(key, t.getInterestOps());
        }
        finally {
            this.server.getLock().unlock();
        }
    }

    public void registerChannel(SocketChannel channel, int ops, NioContext context) {
        this.registerChannel(channel, ops, context, null);
    }

    public void registerChannel(SocketChannel channel, int ops, NioContext context, ChannelRegistrationAction action) {
        SelectionKey key = null;
        try {
            this.server.getLock().lock();
            try {
                this.server.getSelector().wakeup();
                key = channel.register(this.server.getSelector(), ops, context);
                if (action != null) {
                    action.key = key;
                    action.run();
                }
            }
            finally {
                this.server.getLock().unlock();
            }
        }
        catch (ClosedChannelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void submit(Runnable r) {
        r.run();
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public static abstract class ChannelRegistrationAction
    implements Runnable {
        public SelectionKey key = null;
    }
}

