/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.NioState;
import org.jppf.server.nio.StateTransitionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateTransitionTask<S extends Enum<S>, T extends Enum<T>>
implements Runnable {
    private static Log log = LogFactory.getLog(StateTransitionTask.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private SelectionKey key = null;
    private NioContext<S> ctx = null;
    private NioServerFactory<S, T> factory = null;

    public StateTransitionTask(SelectionKey key, NioServerFactory<S, T> factory) {
        this.key = key;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            StateTransitionManager<S, T> transitionManager = this.factory.getServer().getTransitionManager();
            try {
                this.ctx = (NioContext)this.key.attachment();
                S s = this.ctx.getState();
                NioState<T> state = this.factory.getState(this.ctx.getState());
                T transition = state.performTransition(this.key);
                transitionManager.transitionChannel(this.key, transition);
            }
            catch (Exception e) {
                this.ctx.handleException((SocketChannel)this.key.channel());
                if (debugEnabled) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                log.warn((Object)e);
            }
        }
    }
}

