/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.comm.socket.SocketChannelClient;
import org.jppf.server.nio.AbstractSocketChannelHandler;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.StateTransitionManager;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;

public class MultiplexerChannelHandler
extends AbstractSocketChannelHandler {
    private static Log log = LogFactory.getLog(MultiplexerChannelHandler.class);
    private boolean debugEnabled = log.isDebugEnabled();
    private SelectionKey initialKey = null;

    public MultiplexerChannelHandler(NioServer server, String host, int port, SelectionKey initialKey) {
        super(server, host, port);
        this.initialKey = initialKey;
    }

    protected SocketChannelClient initSocketChannel() throws Exception {
        return new SocketChannelClient(this.host, this.port, false);
    }

    protected void postInit() throws Exception {
        SocketChannel channel = this.socketClient.getChannel();
        this.socketClient.setChannel(null);
        MultiplexerContext context = (MultiplexerContext)this.server.createNioContext();
        context.setLinkedKey(this.initialKey);
        context.setState(MultiplexerState.SENDING_MULTIPLEXING_INFO);
        this.server.getTransitionManager().registerChannel(channel, 5, context, new StateTransitionManager.ChannelRegistrationAction(){

            @Override
            public void run() {
                MultiplexerContext initialContext = (MultiplexerContext)MultiplexerChannelHandler.this.initialKey.attachment();
                initialContext.setLinkedKey(this.key);
                MultiplexerChannelHandler.this.server.getTransitionManager().transitionChannel(MultiplexerChannelHandler.this.initialKey, MultiplexerTransition.TO_SENDING_OR_RECEIVING);
            }
        });
        if (this.debugEnabled) {
            log.debug((Object)"registered multiplexer channel");
        }
    }
}

