/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.multiplexer.MultiplexerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexerContext
extends NioContext<MultiplexerState> {
    private SelectionKey linkedKey = null;
    private int boundPort = -1;
    private int multiplexerPort = -1;

    @Override
    public void handleException(SocketChannel channel) {
        try {
            if (this.linkedKey != null && this.linkedKey.channel() != null) {
                try {
                    this.linkedKey.channel().close();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            channel.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized SelectionKey getLinkedKey() {
        return this.linkedKey;
    }

    public synchronized void setLinkedKey(SelectionKey key) {
        this.linkedKey = key;
    }

    public int getBoundPort() {
        return this.boundPort;
    }

    public void setBoundPort(int boundPort) {
        this.boundPort = boundPort;
    }

    public int getMultiplexerPort() {
        return this.multiplexerPort;
    }

    public void setMultiplexerPort(int multiplexerPort) {
        this.multiplexerPort = multiplexerPort;
    }

    public boolean isApplicationPort() {
        return this.boundPort > 0;
    }

    public boolean isMultiplexerPort() {
        return this.multiplexerPort > 0;
    }

    public int readOutBoundPort() {
        if (this.message == null) {
            return -1;
        }
        this.message.buffer.flip();
        return this.message.buffer.getInt();
    }
}

