/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class ReceivingState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(ReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        SelectableChannel channel = key.channel();
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (debugEnabled) {
            log.debug((Object)("exec() for " + StringUtils.getRemoteHost((Channel)channel)));
        }
        if (context.readMessage((ReadableByteChannel)((Object)channel))) {
            if (debugEnabled) {
                log.debug((Object)("read message for " + StringUtils.getRemoteHost((Channel)channel) + " done"));
            }
            SelectionKey linkedKey = context.getLinkedKey();
            NioMessage msg = context.getMessage();
            msg.buffer.flip();
            context.setMessage(null);
            MultiplexerContext linkedContext = (MultiplexerContext)linkedKey.attachment();
            linkedContext.setMessage(msg);
            this.server.getTransitionManager().transitionChannel(linkedKey, MultiplexerTransition.TO_SENDING);
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_RECEIVING;
    }
}

