/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class SendingMultiplexingInfoState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(SendingMultiplexingInfoState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingMultiplexingInfoState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        MultiplexerContext context;
        SelectableChannel channel = key.channel();
        if (key.isReadable()) {
            throw new ConnectException("multiplexer channel " + StringUtils.getRemoteHost((Channel)channel) + " has been disconnected");
        }
        if (debugEnabled) {
            log.debug((Object)("exec() for " + StringUtils.getRemoteHost((Channel)channel)));
        }
        if ((context = (MultiplexerContext)key.attachment()).getMessage() == null) {
            MultiplexerContext linkedContext = (MultiplexerContext)context.getLinkedKey().attachment();
            NioMessage msg = new NioMessage();
            msg.length = 4;
            msg.buffer = ByteBuffer.wrap(new byte[4]);
            msg.buffer.putInt(linkedContext.getBoundPort());
            msg.buffer.flip();
            context.setMessage(msg);
        }
        if (context.writeMessage((WritableByteChannel)((Object)channel))) {
            if (debugEnabled) {
                log.debug((Object)("message sent to remote multiplexer " + StringUtils.getRemoteHost((Channel)channel)));
            }
            context.setMessage(null);
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_SENDING_MULTIPLEXING_INFO;
    }
}

