/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class SendingOrReceivingState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(SendingOrReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingOrReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (context.getMessage() != null) {
            if (debugEnabled) {
                log.debug((Object)("returning TO_SENDING for " + StringUtils.getRemoteHost((Channel)key.channel())));
            }
            return MultiplexerTransition.TO_SENDING;
        }
        if (key.isReadable()) {
            if (debugEnabled) {
                log.debug((Object)("returning TO_RECEIVING for " + StringUtils.getRemoteHost((Channel)key.channel())));
            }
            return MultiplexerTransition.TO_RECEIVING;
        }
        if (debugEnabled) {
            log.debug((Object)("returning TO_SENDING_OR_RECEIVING for " + StringUtils.getRemoteHost((Channel)key.channel())));
        }
        return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
    }
}

