/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.net.ConnectException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class SendingState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(SendingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        SelectableChannel channel = key.channel();
        if (key.isReadable()) {
            throw new ConnectException("multiplexer " + StringUtils.getRemoteHost((Channel)channel) + " has been disconnected");
        }
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (context.writeMessage((WritableByteChannel)((Object)channel))) {
            if (debugEnabled) {
                log.debug((Object)(String.valueOf(StringUtils.getRemoteHost((Channel)channel)) + " message sent"));
            }
            context.setMessage(null);
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_SENDING;
    }
}

