/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.multiplexer.generic.MultiplexerChannelInitializer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.server.nio.multiplexer.generic.OutboundChannelHandler;
import org.jppf.utils.StringUtils;

public class IdentifyingInboundChannelState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(IdentifyingInboundChannelState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public IdentifyingInboundChannelState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        SelectableChannel channel = key.channel();
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (debugEnabled) {
            log.debug((Object)("exec() for " + StringUtils.getRemoteHost((Channel)channel)));
        }
        if (context.readMessage((ReadableByteChannel)((Object)channel))) {
            int port = context.readOutBoundPort();
            if (debugEnabled) {
                log.debug((Object)("read port number for " + StringUtils.getRemoteHost((Channel)channel) + ": " + port));
            }
            if (port <= 0) {
                throw new IOException("outbound port could not be read from this channel");
            }
            OutboundChannelHandler handler = new OutboundChannelHandler(this.server, "localhost", port, key);
            MultiplexerChannelInitializer init = new MultiplexerChannelInitializer(handler);
            context.setMessage(null);
            this.server.getTransitionManager().transitionChannel(key, MultiplexerTransition.TO_IDLE);
            new Thread(init).start();
            return MultiplexerTransition.TO_IDLE;
        }
        return MultiplexerTransition.TO_IDENTIFYING_INBOUND_CHANNEL;
    }
}

