/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.multiplexer.generic.ByteBufferWrapper;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.ReceivingState;
import org.jppf.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexerContext
extends NioContext<MultiplexerState> {
    private static Log log = LogFactory.getLog(ReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private SelectionKey linkedKey = null;
    private int boundPort = -1;
    private int multiplexerPort = -1;
    private Queue<ByteBufferWrapper> pendingMessages = new ConcurrentLinkedQueue<ByteBufferWrapper>();
    private ByteBuffer currentMessage = null;
    public boolean eof = false;
    private int readMessageCount = 0;

    @Override
    public void handleException(SocketChannel channel) {
        try {
            if (this.linkedKey != null && this.linkedKey.channel() != null) {
                try {
                    this.linkedKey.channel().close();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            channel.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized SelectionKey getLinkedKey() {
        return this.linkedKey;
    }

    public synchronized void setLinkedKey(SelectionKey key) {
        this.linkedKey = key;
    }

    public int getBoundPort() {
        return this.boundPort;
    }

    public void setBoundPort(int boundPort) {
        this.boundPort = boundPort;
    }

    public int getMultiplexerPort() {
        return this.multiplexerPort;
    }

    public void setMultiplexerPort(int multiplexerPort) {
        this.multiplexerPort = multiplexerPort;
    }

    public boolean isApplicationPort() {
        return this.boundPort > 0;
    }

    public boolean isMultiplexerPort() {
        return this.multiplexerPort > 0;
    }

    public int readOutBoundPort() {
        if (this.message == null) {
            return -1;
        }
        this.message.buffer.flip();
        return this.message.buffer.getInt();
    }

    public ByteBuffer readMultiplexerMessage(ReadableByteChannel channel) throws Exception {
        ByteBuffer msg = ByteBuffer.wrap(new byte[32768]);
        int count = 0;
        int n = 0;
        do {
            count = channel.read(msg);
            n += count;
        } while (count > 0 && msg.hasRemaining());
        if (debugEnabled) {
            log.debug((Object)("[" + this.getShortClassName() + "] " + "read " + n + " bytes from " + StringUtils.getRemoteHost((Channel)((SocketChannel)channel))));
        }
        if (count < 0) {
            this.setEof(true);
        }
        if (msg.position() > 0) {
            msg.flip();
            return msg;
        }
        return null;
    }

    public boolean writeMultiplexerMessage(WritableByteChannel channel) throws Exception {
        ByteBuffer msg = this.getCurrentMessage();
        int count = 0;
        while ((count = channel.write(msg)) > 0 && msg.hasRemaining()) {
        }
        if (debugEnabled) {
            log.debug((Object)("[" + this.getShortClassName() + "] " + "written " + count + " bytes to " + StringUtils.getRemoteHost((Channel)((SocketChannel)channel))));
        }
        return !msg.hasRemaining();
    }

    public synchronized void addPendingMessage(ByteBufferWrapper message) {
        this.pendingMessages.add(message);
    }

    public synchronized ByteBufferWrapper nextPendingMessage() {
        return this.pendingMessages.poll();
    }

    public synchronized boolean hasPendingMessage() {
        return this.pendingMessages.peek() != null;
    }

    public synchronized ByteBuffer getCurrentMessage() {
        return this.currentMessage;
    }

    public synchronized void setCurrentMessage(ByteBuffer message) {
        this.currentMessage = message;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void setEof(boolean eof) {
        this.eof = eof;
    }

    public synchronized int newReadMessageCount() {
        return ++this.readMessageCount;
    }
}

