/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFException;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.multiplexer.generic.MultiplexerChannelHandler;
import org.jppf.server.nio.multiplexer.generic.MultiplexerChannelInitializer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerFactory;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.utils.HostPort;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexerNioServer
extends NioServer<MultiplexerState, MultiplexerTransition> {
    private static final String THIS_NAME = "MultiplexerServer Thread";
    private static Log log = LogFactory.getLog(MultiplexerNioServer.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Set<String> remoteMultiplexers = new HashSet<String>();
    private Map<String, HostPort> remoteMultiplexerMap = new HashMap<String, HostPort>();
    private Set<Integer> boundPorts = new HashSet<Integer>();
    private Map<Integer, String> boundToMultiplexerMap = new HashMap<Integer, String>();
    private Set<Integer> multiplexerPorts = new HashSet<Integer>();

    public MultiplexerNioServer() throws JPPFException {
        super(THIS_NAME);
        this.selectTimeout = 1L;
        this.configure();
    }

    @Override
    protected NioServerFactory<MultiplexerState, MultiplexerTransition> createFactory() {
        return new MultiplexerServerFactory(this);
    }

    private void configure() throws JPPFException {
        int port;
        int n;
        int n2;
        Object[] objectArray;
        TypedProperties props;
        String s;
        if (debugEnabled) {
            log.debug((Object)"configuring the multiplexer");
        }
        if ((s = (props = JPPFConfiguration.getProperties()).getString("multiplexer.ports")) != null) {
            int[] ports;
            objectArray = ports = StringUtils.parseIntValues((String)s);
            n2 = ports.length;
            n = 0;
            while (n < n2) {
                port = objectArray[n];
                this.multiplexerPorts.add(port);
                ++n;
            }
        }
        if ((s = props.getString("remote.multiplexers")) != null) {
            String[] names = s.split("\\s");
            objectArray = names;
            n2 = names.length;
            n = 0;
            while (n < n2) {
                int name = objectArray[n];
                this.remoteMultiplexers.add((String)name);
                s = props.getString("remote.multiplexer." + (String)name);
                if (s != null) {
                    this.remoteMultiplexerMap.put((String)name, StringUtils.parseHostPort((String)s));
                }
                ++n;
            }
            s = props.getString("bound.ports");
            if (s == null) {
                return;
            }
            this.ports = StringUtils.parseIntValues((String)s);
            objectArray = this.ports;
            n2 = this.ports.length;
            n = 0;
            while (n < n2) {
                port = objectArray[n];
                this.boundPorts.add(port);
                String name = props.getString("mapping." + port, null);
                if (name != null) {
                    this.boundToMultiplexerMap.put(port, name);
                }
                ++n;
            }
        }
        int n3 = this.multiplexerPorts.size() + this.boundPorts.size();
        this.ports = new int[n3];
        int count = 0;
        for (Integer port2 : this.multiplexerPorts) {
            this.ports[count++] = port2;
        }
        for (Integer port3 : this.boundPorts) {
            this.ports[count++] = port3;
        }
        if (debugEnabled) {
            log.debug((Object)("multiplexerPorts: " + this.multiplexerPorts));
            log.debug((Object)("boundPorts: " + this.boundPorts));
            log.debug((Object)("remoteMultiplexers: " + this.remoteMultiplexers));
            log.debug((Object)("remoteMultiplexerMap: " + this.remoteMultiplexerMap));
            log.debug((Object)("boundToMultiplexerMap: " + this.boundToMultiplexerMap));
        }
        this.init(this.ports);
    }

    @Override
    public NioContext createNioContext() {
        return new MultiplexerContext();
    }

    @Override
    public int getInitialInterest() {
        return 5;
    }

    @Override
    public void postAccept(SelectionKey key, ServerSocketChannel serverChannel) {
        int port = serverChannel.socket().getLocalPort();
        if (debugEnabled) {
            log.debug((Object)("accepting on port " + port));
        }
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (this.multiplexerPorts.contains(port)) {
            context.setMultiplexerPort(port);
        } else if (this.boundPorts.contains(port)) {
            context.setBoundPort(port);
        }
        this.postAccept(key);
    }

    @Override
    public void postAccept(SelectionKey key) {
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (context.isApplicationPort()) {
            if (debugEnabled) {
                log.debug((Object)("initializing outbound port " + context.getBoundPort()));
            }
            this.transitionManager.transitionChannel(key, MultiplexerTransition.TO_IDLE);
            HostPort mult = this.getHostPortForBoundPort(context.getBoundPort());
            MultiplexerChannelHandler handler = new MultiplexerChannelHandler(this, mult.host(), mult.port(), key);
            MultiplexerChannelInitializer init = new MultiplexerChannelInitializer(handler);
            new Thread(init).start();
        } else if (context.isMultiplexerPort()) {
            if (debugEnabled) {
                log.debug((Object)("initializing multiplexing port " + context.getMultiplexerPort()));
            }
            this.transitionManager.transitionChannel(key, MultiplexerTransition.TO_IDENTIFYING_INBOUND_CHANNEL);
        }
    }

    public HostPort getHostPortForBoundPort(int port) {
        String name = this.boundToMultiplexerMap.get(port);
        if (name == null) {
            return null;
        }
        return this.remoteMultiplexerMap.get(name);
    }

    public static void main(String ... args) {
        try {
            MultiplexerNioServer svr = new MultiplexerNioServer();
            svr.start();
            svr.join();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }
}

