/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.multiplexer.generic.ByteBufferWrapper;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class ReceivingState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(ReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        ByteBuffer message;
        SelectableChannel channel = key.channel();
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (debugEnabled) {
            log.debug((Object)("exec() for " + StringUtils.getRemoteHost((Channel)channel)));
        }
        if ((message = context.readMultiplexerMessage((ReadableByteChannel)((Object)channel))) != null) {
            if (debugEnabled) {
                log.debug((Object)("read message for " + StringUtils.getRemoteHost((Channel)channel) + " done"));
            }
            SelectionKey linkedKey = context.getLinkedKey();
            MultiplexerContext linkedContext = (MultiplexerContext)linkedKey.attachment();
            linkedContext.addPendingMessage(new ByteBufferWrapper(message, context.newReadMessageCount()));
            if (!MultiplexerState.SENDING.equals(linkedContext.getState())) {
                this.server.getTransitionManager().transitionChannel(linkedKey, MultiplexerTransition.TO_SENDING);
            }
            if (!context.isEof()) {
                return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
            }
        }
        if (context.isEof()) {
            context.setEof(false);
            return MultiplexerTransition.TO_IDLE;
        }
        return MultiplexerTransition.TO_RECEIVING;
    }
}

