/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class SendingOrReceivingState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(SendingOrReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingOrReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        MultiplexerTransition trans = MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        if (context.hasPendingMessage() || context.getCurrentMessage() != null) {
            trans = MultiplexerTransition.TO_SENDING;
        } else if (key.isReadable()) {
            trans = MultiplexerTransition.TO_RECEIVING;
        }
        if (debugEnabled) {
            log.debug((Object)("returning " + (Object)((Object)trans) + " for " + StringUtils.getRemoteHost((Channel)key.channel())));
        }
        return trans;
    }
}

