/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.nio.multiplexer.generic.ByteBufferWrapper;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.utils.StringUtils;

public class SendingState
extends MultiplexerServerState {
    private static Log log = LogFactory.getLog(SendingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingState(MultiplexerNioServer server) {
        super(server);
    }

    public MultiplexerTransition performTransition(SelectionKey key) throws Exception {
        SelectableChannel channel = key.channel();
        MultiplexerContext context = (MultiplexerContext)key.attachment();
        if (context.hasPendingMessage() && context.getCurrentMessage() == null) {
            ByteBufferWrapper message = context.nextPendingMessage();
            context.setCurrentMessage(message.buffer);
            if (debugEnabled) {
                log.debug((Object)(String.valueOf(StringUtils.getRemoteHost((Channel)channel)) + " about to send message #" + message.order + ": " + (message.buffer.limit() + 1) + " bytes"));
            }
        }
        if (context.getCurrentMessage() == null) {
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        if (context.writeMultiplexerMessage((WritableByteChannel)((Object)channel))) {
            if (debugEnabled) {
                log.debug((Object)(String.valueOf(StringUtils.getRemoteHost((Channel)channel)) + " message sent"));
            }
            context.setCurrentMessage(null);
            return context.hasPendingMessage() ? MultiplexerTransition.TO_SENDING : MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_SENDING;
    }
}

