/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jppf.server.protocol.Location;
import org.jppf.server.protocol.LocationEvent;
import org.jppf.server.protocol.LocationEventListener;
import org.jppf.utils.JPPFByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocation<T>
implements Serializable,
Location<T> {
    protected T path = null;
    protected List<LocationEventListener> listeners = new ArrayList<LocationEventListener>();
    protected boolean eventsEnabled = false;

    public AbstractLocation(T path) {
        this.path = path;
    }

    @Override
    public T getPath() {
        return this.path;
    }

    @Override
    public void copyTo(Location location) throws Exception {
        InputStream is = this.getInputStream();
        OutputStream os = location.getOutputStream();
        this.copyStream(is, os);
        is.close();
        os.flush();
        os.close();
    }

    @Override
    public byte[] toByteArray() throws Exception {
        InputStream is = this.getInputStream();
        JPPFByteArrayOutputStream os = new JPPFByteArrayOutputStream();
        this.copyStream(is, (OutputStream)os);
        is.close();
        os.flush();
        os.close();
        return os.toByteArray();
    }

    public String toString() {
        return "" + this.getPath();
    }

    @Override
    public void addLocationEventListener(LocationEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener not accepted");
        }
        this.listeners.add(listener);
        if (!this.eventsEnabled) {
            this.eventsEnabled = true;
        }
    }

    @Override
    public void removeLocationEventListener(LocationEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener not accepted");
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.eventsEnabled = false;
        }
    }

    protected void fireLocationEvent(int n) {
        if (this.listeners.isEmpty()) {
            return;
        }
        LocationEvent event = new LocationEvent(this, n);
        for (LocationEventListener l : this.listeners) {
            l.dataTransferred(event);
        }
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] bytes = new byte[32768];
        while ((n = is.read(bytes)) > 0) {
            if (this.eventsEnabled) {
                this.fireLocationEvent(n);
            }
            os.write(bytes, 0, n);
        }
    }
}

