/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.List;
import org.jppf.io.DataLocation;
import org.jppf.server.protocol.JPPFTaskBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWrapper {
    private JPPFTaskBundle bundle = null;
    private DataLocation dataProvider = null;
    private List<DataLocation> tasks = new ArrayList<DataLocation>();

    public BundleWrapper() {
    }

    public BundleWrapper(JPPFTaskBundle bundle) {
        this.bundle = bundle;
    }

    public JPPFTaskBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(JPPFTaskBundle bundle) {
        this.bundle = bundle;
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataLocation dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void addTask(DataLocation task) {
        this.tasks.add(task);
    }

    public List<DataLocation> getTasks() {
        return this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleWrapper copy(int nbTasks) {
        BundleWrapper wrapper = null;
        BundleWrapper bundleWrapper = this;
        synchronized (bundleWrapper) {
            wrapper = new BundleWrapper(this.bundle.copy(nbTasks));
            int i = 0;
            while (i < nbTasks) {
                wrapper.addTask(this.tasks.remove(0));
                ++i;
            }
        }
        wrapper.setDataProvider(this.dataProvider.copy());
        return wrapper;
    }

    public void merge(BundleWrapper other, boolean after) {
        int n = other.getBundle().getTaskCount();
        this.bundle.setTaskCount(this.bundle.getTaskCount() + n);
        this.bundle.getJobSLA().setSuspended(other.getBundle().getJobSLA().isSuspended());
        if (after) {
            for (DataLocation task : other.getTasks()) {
                this.tasks.add(task);
            }
        } else {
            int i = n - 1;
            while (i >= 0) {
                this.tasks.add(0, other.getTasks().get(i));
                --i;
            }
        }
    }
}

