/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jppf.process.ProcessWrapper;
import org.jppf.process.event.ProcessWrapperEvent;
import org.jppf.process.event.ProcessWrapperEventListener;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandLineTask
extends JPPFTask
implements ProcessWrapperEventListener {
    private static final long serialVersionUID = 1L;
    private List<String> commandList = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private String startDir = null;
    private StringBuilder standardOutput = new StringBuilder();
    private StringBuilder errorOutput = new StringBuilder();
    private boolean captureOutput = false;

    public CommandLineTask() {
    }

    public CommandLineTask(String ... commands) {
        this((Map<String, String>)null, (String)null, commands);
    }

    public CommandLineTask(Map<String, String> env, String startDir, String ... commands) {
        if (commands != null) {
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.commandList.add(s);
                ++n2;
            }
        }
        this.env = env;
        this.startDir = startDir;
    }

    public void launchProcess() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(this.commandList);
        if (this.startDir != null) {
            builder.directory(new File(this.startDir));
        }
        if (this.env != null) {
            Map<String, String> map = builder.environment();
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
        }
        ProcessWrapper wrapper = new ProcessWrapper();
        if (this.captureOutput) {
            wrapper.addListener((EventListener)((Object)this));
        }
        Process p = builder.start();
        wrapper.setProcess(p);
        p.waitFor();
        if (this.captureOutput) {
            wrapper.removeListener((EventListener)((Object)this));
        }
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public void setCaptureOutput(boolean captureOutput) {
        this.captureOutput = captureOutput;
    }

    public String getStandardOutput() {
        return this.standardOutput.toString();
    }

    public String getErrorOutput() {
        return this.errorOutput.toString();
    }

    public List<String> getCommandList() {
        return this.commandList;
    }

    public void setCommandList(List<String> commandList) {
        this.commandList = commandList;
    }

    public void setCommandList(String ... commands) {
        this.commandList = CollectionUtils.list(commands);
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public String getStartDir() {
        return this.startDir;
    }

    public void setStartDir(String startDir) {
        this.startDir = startDir;
    }

    public void outputStreamAltered(ProcessWrapperEvent event) {
        this.standardOutput.append(event.getContent()).append("\n");
    }

    public void errorStreamAltered(ProcessWrapperEvent event) {
        this.errorOutput.append(event.getContent()).append("\n");
    }
}

