/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.server.protocol.JPPFTaskEvent;
import org.jppf.server.protocol.JPPFTaskListener;
import org.jppf.task.storage.DataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPPFTask
implements Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int position;
    private Object result = null;
    private Exception exception = null;
    private transient DataProvider dataProvider = null;
    protected transient List<JPPFTaskListener> listeners = null;
    private JPPFSchedule timeoutSchedule = null;
    private String id = null;

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int position) {
        this.position = position;
    }

    public synchronized void addJPPFTaskListener(JPPFTaskListener listener) {
        this.getListeners().add(listener);
    }

    public synchronized void removeJPPFTaskListener(JPPFTaskListener listener) {
        this.getListeners().remove(listener);
    }

    public synchronized void fireNotification(Serializable source) {
        JPPFTaskListener[] array;
        JPPFTaskEvent event = new JPPFTaskEvent(source);
        JPPFTaskListener[] jPPFTaskListenerArray = array = this.getListeners().toArray(new JPPFTaskListener[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            JPPFTaskListener listener = jPPFTaskListenerArray[n2];
            listener.eventOccurred(event);
            ++n2;
        }
    }

    protected synchronized List<JPPFTaskListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<JPPFTaskListener>();
        }
        return this.listeners;
    }

    public long getTimeout() {
        if (this.timeoutSchedule == null) {
            return 0L;
        }
        return this.timeoutSchedule.getDuration();
    }

    public void setTimeout(long timeout) {
        this.timeoutSchedule = new JPPFSchedule(timeout);
    }

    public String getTimeoutDate() {
        if (this.timeoutSchedule == null) {
            return null;
        }
        return this.timeoutSchedule.getDate();
    }

    public SimpleDateFormat getTimeoutDateFormat() {
        if (this.timeoutSchedule == null) {
            return null;
        }
        return new SimpleDateFormat(this.timeoutSchedule.getFormat());
    }

    public String getTimeoutFormat() {
        if (this.timeoutSchedule == null) {
            return null;
        }
        return this.timeoutSchedule.getFormat();
    }

    public void setTimeoutDate(String timeoutDate, SimpleDateFormat timeoutDateFormat) {
        this.timeoutSchedule = new JPPFSchedule(timeoutDate, timeoutDateFormat.toPattern());
    }

    public void setTimeoutDate(String timeoutDate, String format) {
        this.timeoutSchedule = new JPPFSchedule(timeoutDate, format);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void onCancel() {
    }

    public void onRestart() {
    }

    public void onTimeout() {
    }

    public Object getTaskObject() {
        return null;
    }

    public JPPFSchedule getTimeoutSchedule() {
        return this.timeoutSchedule;
    }

    public void setTimeoutSchedule(JPPFSchedule timeoutSchedule) {
        this.timeoutSchedule = timeoutSchedule;
    }
}

