/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFDistributedJob;
import org.jppf.server.protocol.JPPFJobMetadata;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.server.protocol.TaskCompletionListener;
import org.jppf.utils.TraversalList;
import org.jppf.utils.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFTaskBundle
implements Serializable,
Comparable<JPPFTaskBundle>,
JPPFDistributedJob {
    private static final long serialVersionUID = 1L;
    private String uuid = null;
    private String requestUuid = null;
    private TraversalList<String> uuidPath = new TraversalList();
    private int taskCount = 0;
    private int initialTaskCount = 0;
    private transient byte[] dataProvider = null;
    private transient List<byte[]> tasks = null;
    private transient long queueEntryTime = 0L;
    private transient TaskCompletionListener completionListener = null;
    private long nodeExecutionTime = 0L;
    private long executionStartTime = 0L;
    private int buildNumber = 0;
    private State state = State.EXECUTION_BUNDLE;
    private Map<Object, Object> parameters = new HashMap<Object, Object>();
    private JPPFJobSLA jobSLA = new JPPFJobSLA();

    public JPPFTaskBundle() {
        this.buildNumber = VersionUtils.getBuildNumber();
    }

    public String getBundleUuid() {
        return this.uuid;
    }

    public void setBundleUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getRequestUuid() {
        return this.requestUuid;
    }

    public void setRequestUuid(String requestUuid) {
        this.requestUuid = requestUuid;
    }

    public byte[] getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(byte[] dataProvider) {
        this.dataProvider = dataProvider;
    }

    public TraversalList<String> getUuidPath() {
        return this.uuidPath;
    }

    public void setUuidPath(TraversalList<String> uuidPath) {
        this.uuidPath = uuidPath;
    }

    public long getQueueEntryTime() {
        return this.queueEntryTime;
    }

    public void setQueueEntryTime(long queueEntryTime) {
        this.queueEntryTime = queueEntryTime;
    }

    public long getNodeExecutionTime() {
        return this.nodeExecutionTime;
    }

    public void setNodeExecutionTime(long nodeExecutionTime) {
        this.nodeExecutionTime = nodeExecutionTime;
    }

    public List<byte[]> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<byte[]> tasks) {
        this.tasks = tasks;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
        if (this.initialTaskCount <= 0) {
            this.initialTaskCount = taskCount;
        }
    }

    public TaskCompletionListener getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(TaskCompletionListener listener) {
        this.completionListener = listener;
    }

    @Override
    public int compareTo(JPPFTaskBundle bundle) {
        if (bundle == null) {
            return 1;
        }
        int otherPriority = bundle.getJobSLA().getPriority();
        if (this.jobSLA.getPriority() < otherPriority) {
            return -1;
        }
        if (this.jobSLA.getPriority() > otherPriority) {
            return 1;
        }
        return 0;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public JPPFTaskBundle copy(int nbTasks) {
        JPPFTaskBundle bundle = new JPPFTaskBundle();
        bundle.setBundleUuid(this.uuid);
        bundle.setUuidPath(this.uuidPath);
        bundle.setRequestUuid(this.requestUuid);
        bundle.setTaskCount(nbTasks);
        bundle.setDataProvider(this.dataProvider);
        this.taskCount -= nbTasks;
        bundle.getParametersMap().putAll(this.parameters);
        bundle.setQueueEntryTime(this.queueEntryTime);
        bundle.setCompletionListener(this.completionListener);
        return bundle;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(long executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public int getInitialTaskCount() {
        return this.initialTaskCount;
    }

    public void setParameter(Object name, Object value) {
        this.parameters.put(name, value);
    }

    public Object getParameter(Object name) {
        return this.parameters.get(name);
    }

    public Object getParameter(Object name, Object defaultValue) {
        Object res = this.parameters.get(name);
        return res == null ? defaultValue : res;
    }

    public Object removeParameter(Object name) {
        return this.parameters.remove(name);
    }

    public Map<Object, Object> getParametersMap() {
        return this.parameters;
    }

    @Override
    public JPPFJobSLA getJobSLA() {
        return this.jobSLA;
    }

    public void setJobSLA(JPPFJobSLA jobSLA) {
        this.jobSLA = jobSLA;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("jobId=").append(this.getParameter((Object)BundleParameter.JOB_ID));
        sb.append(", jobUuid=").append(this.getParameter((Object)BundleParameter.JOB_UUID));
        sb.append(", initialTaskCount=").append(this.initialTaskCount);
        sb.append(", taskCount=").append(this.taskCount);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getId() {
        return (String)this.getParameter((Object)BundleParameter.JOB_ID);
    }

    @Override
    public JPPFJobMetadata getJobMetadata() {
        return (JPPFJobMetadata)this.getParameter((Object)BundleParameter.JOB_METADATA);
    }

    @Override
    public String getJobUuid() {
        return (String)this.getParameter((Object)BundleParameter.JOB_UUID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIAL_BUNDLE,
        EXECUTION_BUNDLE;

    }
}

