/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle;

import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;

public abstract class AbstractBundler
implements Bundler {
    private static AtomicInteger bundlerCount = new AtomicInteger(0);
    protected int bundlerNumber = AbstractBundler.incBundlerCount();
    protected long timestamp = System.currentTimeMillis();
    protected LoadBalancingProfile profile;

    private AbstractBundler() {
    }

    public AbstractBundler(LoadBalancingProfile profile) {
        this.profile = profile;
    }

    private static int incBundlerCount() {
        return bundlerCount.incrementAndGet();
    }

    protected abstract int maxSize();

    public void feedback(int bundleSize, double totalTime) {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getBundlerNumber() {
        return this.bundlerNumber;
    }

    public void setup() {
    }

    public void dispose() {
    }

    public LoadBalancingProfile getProfile() {
        return this.profile;
    }
}

