/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle;

import java.util.LinkedList;
import org.jppf.server.scheduler.bundle.BundlePerformanceSample;

public class BundleDataHolder {
    private LinkedList<BundlePerformanceSample> samples = new LinkedList();
    private double mean = 0.0;
    private double previousMean = 0.0;
    private double totalTime = 0.0;
    private long nbSamples = 0L;
    private int performanceCacheSize = 0;

    public BundleDataHolder(int performanceCacheSize) {
        this.performanceCacheSize = performanceCacheSize;
    }

    public void addSample(BundlePerformanceSample sample) {
        boolean b;
        boolean bl = b = sample.samples + this.nbSamples > (long)this.performanceCacheSize || this.samples.isEmpty();
        if (b) {
            while (sample.samples + this.nbSamples > (long)this.performanceCacheSize && !this.samples.isEmpty()) {
                this.removeHeadSample();
            }
        }
        this.samples.add(sample);
        this.totalTime += (double)sample.samples * sample.mean;
        this.nbSamples += sample.samples;
        this.computeMean();
    }

    private void removeHeadSample() {
        BundlePerformanceSample sample = this.samples.removeFirst();
        this.nbSamples -= sample.samples;
        this.totalTime -= (double)sample.samples * sample.mean;
    }

    private void computeMean() {
        if (this.nbSamples > 0L) {
            this.previousMean = this.mean;
            this.mean = this.totalTime / (double)this.nbSamples;
        }
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getPreviousMean() {
        return this.previousMean;
    }

    public int getPerformanceCacheSize() {
        return this.performanceCacheSize;
    }

    public void setPerformanceCacheSize(int performanceCacheSize) {
        this.performanceCacheSize = performanceCacheSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mean = ").append(this.mean).append(", previousMean = ").append(this.previousMean);
        sb.append(", totalTime = ").append(this.totalTime).append(", nbSamples = ").append(this.nbSamples);
        sb.append(", maLength = ").append(this.performanceCacheSize).append(", samples.size() = ").append(this.samples.size());
        return sb.toString();
    }

    public long getNbSamples() {
        return this.nbSamples;
    }
}

