/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.autotuned;

import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.autotuned.AbstractAutoTuneProfile;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

public class AnnealingTuneProfile
extends AbstractAutoTuneProfile {
    private static AtomicReference<AnnealingTuneProfile> defaultProfile = new AtomicReference<AnnealingTuneProfile>(new AnnealingTuneProfile());
    protected long minSamplesToAnalyse = 500L;
    protected long minSamplesToCheckConvergence = 300L;
    protected double maxDeviation = 0.2;
    protected int maxGuessToStable = 10;
    protected float sizeRatioDeviation = 1.5f;
    protected float decreaseRatio = 0.2f;

    public AnnealingTuneProfile() {
    }

    public AnnealingTuneProfile(String profileName) {
        String prefix = "strategy." + profileName + ".";
        TypedProperties props = JPPFConfiguration.getProperties();
        this.minSamplesToAnalyse = props.getInt(String.valueOf(prefix) + "minSamplesToAnalyse", 500);
        this.minSamplesToCheckConvergence = props.getInt(String.valueOf(prefix) + "minSamplesToCheckConvergence", 300);
        this.maxDeviation = props.getDouble(String.valueOf(prefix) + "maxDeviation", 0.2);
        this.maxGuessToStable = props.getInt(String.valueOf(prefix) + "maxGuessToStable", 10);
        this.sizeRatioDeviation = props.getFloat(String.valueOf(prefix) + "sizeRatioDeviation", 1.5f);
        this.decreaseRatio = props.getFloat(String.valueOf(prefix) + "decreaseRatio", 0.2f);
    }

    public AnnealingTuneProfile(TypedProperties config) {
        this.minSamplesToAnalyse = config.getInt("minSamplesToAnalyse", 500);
        this.minSamplesToCheckConvergence = config.getInt("minSamplesToCheckConvergence", 300);
        this.maxDeviation = config.getDouble("maxDeviation", 0.2);
        this.maxGuessToStable = config.getInt("maxGuessToStable", 10);
        this.sizeRatioDeviation = config.getFloat("sizeRatioDeviation", 1.5f);
        this.decreaseRatio = config.getFloat("decreaseRatio", 0.2f);
    }

    public float getSizeRatioDeviation() {
        return this.sizeRatioDeviation;
    }

    public void setSizeRatioDeviation(float sizeRatioDeviation) {
        this.sizeRatioDeviation = sizeRatioDeviation;
    }

    public float getDecreaseRatio() {
        return this.decreaseRatio;
    }

    public void setDecreaseRatio(float decreaseRatio) {
        this.decreaseRatio = decreaseRatio;
    }

    public int createDiff(int bestSize, int collectedSamples, Random rnd) {
        double max = Math.max(Math.round((float)bestSize * (this.getSizeRatioDeviation() - 1.0f)), 1);
        if (max < 1.0) {
            return 1;
        }
        return rnd.nextInt((int)max) + 1;
    }

    protected double expDist(long max, long x) {
        return (double)max / (double)((float)x * this.decreaseRatio);
    }

    public long getMinSamplesToAnalyse() {
        return this.minSamplesToAnalyse;
    }

    public void setMinSamplesToAnalyse(long minSamplesToAnalyse) {
        this.minSamplesToAnalyse = minSamplesToAnalyse;
    }

    public long getMinSamplesToCheckConvergence() {
        return this.minSamplesToCheckConvergence;
    }

    public void setMinSamplesToCheckConvergence(long minSamplesToCheckConvergence) {
        this.minSamplesToCheckConvergence = minSamplesToCheckConvergence;
    }

    public double getMaxDeviation() {
        return this.maxDeviation;
    }

    public void setMaxDeviation(double maxDeviation) {
        this.maxDeviation = maxDeviation;
    }

    public int getMaxGuessToStable() {
        return this.maxGuessToStable;
    }

    public void setMaxGuessToStable(int maxGuessToStable) {
        this.maxGuessToStable = maxGuessToStable;
    }

    public LoadBalancingProfile copy() {
        AnnealingTuneProfile p = new AnnealingTuneProfile();
        p.minSamplesToAnalyse = this.minSamplesToAnalyse;
        p.minSamplesToCheckConvergence = this.minSamplesToCheckConvergence;
        p.maxDeviation = this.maxDeviation;
        p.maxGuessToStable = this.maxGuessToStable;
        p.sizeRatioDeviation = this.sizeRatioDeviation;
        p.decreaseRatio = this.decreaseRatio;
        return p;
    }

    public static AnnealingTuneProfile getDefaultProfile() {
        return defaultProfile.get();
    }
}

