/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.proportional;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.autotuned.AbstractAutoTuneProfile;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

public class ProportionalTuneProfile
extends AbstractAutoTuneProfile {
    private static Log log = LogFactory.getLog(ProportionalTuneProfile.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static AtomicReference<ProportionalTuneProfile> defaultProfile = new AtomicReference<ProportionalTuneProfile>(new ProportionalTuneProfile());
    private int performanceCacheSize = 2000;
    private int proportionalityFactor = 2;

    public ProportionalTuneProfile() {
        if (debugEnabled) {
            log.debug((Object)"in default constructor");
        }
    }

    public ProportionalTuneProfile(String profileName) {
        if (debugEnabled) {
            log.debug((Object)"in constructor with profile name");
        }
        String prefix = "strategy." + profileName + ".";
        TypedProperties props = JPPFConfiguration.getProperties();
        this.performanceCacheSize = props.getInt(String.valueOf(prefix) + "performanceCacheSize", 2000);
        this.proportionalityFactor = props.getInt(String.valueOf(prefix) + "proportionalityFactor", 2);
    }

    public ProportionalTuneProfile(TypedProperties config) {
        if (debugEnabled) {
            log.debug((Object)"in constructor with profile name");
        }
        this.performanceCacheSize = config.getInt("performanceCacheSize", 2000);
        this.proportionalityFactor = config.getInt("proportionalityFactor", 2);
    }

    public LoadBalancingProfile copy() {
        ProportionalTuneProfile other = new ProportionalTuneProfile();
        other.setPerformanceCacheSize(this.performanceCacheSize);
        other.setProportionalityFactor(this.proportionalityFactor);
        return other;
    }

    public int getPerformanceCacheSize() {
        return this.performanceCacheSize;
    }

    public void setPerformanceCacheSize(int performanceCacheSize) {
        this.performanceCacheSize = performanceCacheSize;
    }

    public int getProportionalityFactor() {
        return this.proportionalityFactor;
    }

    public void setProportionalityFactor(int proportionalityFactor) {
        this.proportionalityFactor = proportionalityFactor;
    }

    public static ProportionalTuneProfile getDefaultProfile() {
        return defaultProfile.get();
    }

    public String toString() {
        return "performanceCacheSize=" + this.performanceCacheSize + ", proportionalityFactor=" + this.proportionalityFactor;
    }
}

