/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.rl;

import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.autotuned.AbstractAutoTuneProfile;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

public class RLProfile
extends AbstractAutoTuneProfile {
    private int performanceCacheSize = 2000;
    private double performanceVariationThreshold = 0.05;
    private int maxActionRange = 50;

    public RLProfile() {
    }

    public RLProfile(String profileName) {
        String prefix = "strategy." + profileName + ".";
        TypedProperties props = JPPFConfiguration.getProperties();
        this.performanceCacheSize = props.getInt(String.valueOf(prefix) + "performanceCacheSize", 2000);
        this.performanceVariationThreshold = props.getDouble(String.valueOf(prefix) + "performanceVariationThreshold", 0.05);
        this.maxActionRange = props.getInt(String.valueOf(prefix) + "maxActionRange", 50);
    }

    public RLProfile(TypedProperties config) {
        this.performanceCacheSize = config.getInt("performanceCacheSize", 2000);
        this.performanceVariationThreshold = config.getDouble("performanceVariationThreshold", 0.05);
        this.maxActionRange = config.getInt("maxActionRange", 50);
    }

    public LoadBalancingProfile copy() {
        RLProfile other = new RLProfile();
        other.setPerformanceCacheSize(this.performanceCacheSize);
        other.setPerformanceVariationThreshold(this.performanceVariationThreshold);
        other.setMaxActionRange(this.maxActionRange);
        return other;
    }

    public int getPerformanceCacheSize() {
        return this.performanceCacheSize;
    }

    public void setPerformanceCacheSize(int performanceCacheSize) {
        this.performanceCacheSize = performanceCacheSize;
    }

    public double getPerformanceVariationThreshold() {
        return this.performanceVariationThreshold;
    }

    public void setPerformanceVariationThreshold(double performanceVariationThreshold) {
        this.performanceVariationThreshold = performanceVariationThreshold;
    }

    public int getMaxActionRange() {
        return this.maxActionRange;
    }

    public void setMaxActionRange(int maxActionRange) {
        this.maxActionRange = maxActionRange;
    }
}

