/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.spi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFException;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.spi.JPPFBundlerProvider;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFBundlerFactory {
    private static Log log = LogFactory.getLog(JPPFBundlerFactory.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Map<String, JPPFBundlerProvider> providerMap = null;

    public Bundler createBundler(String name, TypedProperties configuration) throws Exception {
        JPPFBundlerProvider provider = this.getBundlerProvider(name);
        if (provider == null) {
            throw new JPPFException("Provider '" + name + "' could not be found");
        }
        LoadBalancingProfile profile = provider.createProfile(configuration);
        return provider.createBundler(profile);
    }

    public Bundler createBundlerFromJPPFConfiguration() throws Exception {
        String profileName;
        TypedProperties props = JPPFConfiguration.getProperties();
        String algorithm = props.getString("jppf.load.balancing.algorithm", null);
        if (algorithm == null) {
            algorithm = props.getString("task.bundle.strategy", "manual");
        }
        if ((profileName = props.getString("jppf.load.balancing.strategy", null)) == null) {
            profileName = props.getString("task.bundle.autotuned.strategy", "jppf");
        }
        TypedProperties configuration = this.convertJPPFConfiguration(profileName, props);
        return this.createBundler(algorithm, configuration);
    }

    public JPPFBundlerProvider getBundlerProvider(String name) throws Exception {
        if (this.providerMap == null) {
            this.loadProviders();
        }
        return this.providerMap.get(name);
    }

    public List<String> getBundlerProviderNames() throws Exception {
        if (this.providerMap == null) {
            this.loadProviders();
        }
        ArrayList<String> list = new ArrayList<String>(this.providerMap.keySet());
        return list;
    }

    private void loadProviders() throws Exception {
        Hashtable<String, JPPFBundlerProvider> map = new Hashtable<String, JPPFBundlerProvider>();
        Iterator<JPPFBundlerProvider> it = ServiceRegistry.lookupProviders(JPPFBundlerProvider.class);
        while (it.hasNext()) {
            JPPFBundlerProvider provider = it.next();
            map.put(provider.getAlgorithmName(), provider);
            if (!debugEnabled) continue;
            log.debug((Object)("registering new load-balancing algorithm provider '" + provider.getAlgorithmName() + "'"));
        }
        this.providerMap = map;
    }

    public TypedProperties convertJPPFConfiguration(String profileName, TypedProperties configuration) {
        TypedProperties profile = this.extractJPPFConfiguration(profileName, configuration);
        String prefix = "strategy." + profileName + ".";
        Set entries = profile.entrySet();
        TypedProperties result = new TypedProperties();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String s = key.substring(prefix.length());
            result.setProperty(s, (String)entry.getValue());
        }
        return result;
    }

    public TypedProperties extractJPPFConfiguration(String profileName, TypedProperties configuration) {
        TypedProperties profile = new TypedProperties();
        String prefix = "strategy." + profileName + ".";
        Set entries = configuration.entrySet();
        for (Map.Entry entry : entries) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith(prefix)) continue;
            profile.setProperty(key, (String)entry.getValue());
        }
        return profile;
    }
}

