/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Set<T> set(T ... array) {
        HashSet<T> newSet = new HashSet<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            newSet.add(element);
            ++n2;
        }
        return newSet;
    }

    public static <T> List<T> list(T ... array) {
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            list.add(element);
            ++n2;
        }
        return list;
    }

    public static <T> T[] concatArrays(T[] ... arrays) {
        if (arrays == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        T[][] TArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array;
            T[] TArray2 = array = TArray[n2];
            int n3 = array.length;
            int n4 = 0;
            while (n4 < n3) {
                T t = TArray2[n4];
                result.add(t);
                ++n4;
            }
            ++n2;
        }
        return result.toArray((Object[])Array.newInstance(arrays[0][0].getClass(), 0));
    }

    public static <T, U> void putInListMap(T key, U value, Map<T, List<U>> map) {
        List<U> list = map.get(key);
        if (list == null) {
            list = new ArrayList<U>();
            map.put(key, list);
        }
        list.add(value);
    }

    public static <T, U> void removeFromListMap(T key, U value, Map<T, List<U>> map) {
        List<U> list = map.get(key);
        if (list == null) {
            return;
        }
        list.remove(value);
        if (list.isEmpty()) {
            map.remove(key);
        }
    }

    public static <T, U> int sizeOfListMap(Map<T, List<U>> map) {
        int result = 0;
        for (Map.Entry<T, List<U>> entry : map.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public static <T, U> String formatSizeMapInfo(String name, Map<T, List<U>> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("[shallow size=").append(map.size());
        sb.append(", total elements=").append(CollectionUtils.sizeOfListMap(map)).append("]");
        return sb.toString();
    }

    public static <T> List<T> getAllElements(List<T> source, int start, int size) {
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        while (i < size) {
            result.add(source.get(i + start));
            ++i;
        }
        return result;
    }
}

