/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.utils.FileUtils;

public class FileReplacer {
    private static Log log = LogFactory.getLog(FileReplacer.class);
    private boolean debugEnabled = log.isDebugEnabled();
    private String src = null;
    private String dest = null;
    private boolean searchOnly = true;
    private Pattern pattern = null;
    private ReplacerFilter filter = null;
    private int nbReplacements = 0;
    private int nbFilesChanged = 0;

    public void replace(String rootDir, String srcFile, String destFile, String ext, boolean searchOnly) throws Exception {
        this.src = FileUtils.readTextFile((String)srcFile);
        this.dest = FileUtils.readTextFile((String)destFile);
        if (this.src.endsWith("\n") && this.dest.endsWith("\n")) {
            this.src = this.src.substring(0, this.src.length() - 1);
            this.dest = this.dest.substring(0, this.dest.length() - 1);
        }
        this.searchOnly = searchOnly;
        this.pattern = Pattern.compile(this.src, 16);
        this.filter = new ReplacerFilter(ext);
        File f = new File(rootDir);
        this.nbFilesChanged = 0;
        this.nbReplacements = 0;
        if (f.isDirectory()) {
            this.replaceFolder(f);
        } else {
            this.replaceFile(f);
        }
        log.info((Object)("Total number of occurences found: " + this.nbReplacements));
        log.info((Object)("Total number of files" + (searchOnly ? " would have been" : "") + " changed: " + this.nbFilesChanged));
    }

    private void replaceFolder(File folder) throws Exception {
        if (this.debugEnabled) {
            log.info((Object)("Processing folder " + folder.getAbsolutePath()));
        }
        File[] fileList = folder.listFiles(this.filter);
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                folders.add(f);
            } else {
                files.add(f);
            }
            ++n2;
        }
        for (File f : files) {
            this.replaceFile(f);
        }
        for (File f : folders) {
            this.replaceFolder(f);
        }
    }

    private void replaceFile(File file) throws Exception {
        String content = FileUtils.readTextFile((String)file.getPath());
        Matcher matcher = this.pattern.matcher(content);
        boolean b = true;
        int nbFound = 0;
        int start = 0;
        while (b) {
            b = matcher.find(start);
            if (!b) continue;
            ++nbFound;
            start = matcher.end();
        }
        if (nbFound > 0) {
            ++this.nbFilesChanged;
            this.nbReplacements += nbFound;
            log.info((Object)("Found " + nbFound + " occurrence" + (nbFound > 1 ? "s" : "") + " of the sequence in file '" + file + "'"));
            String s = matcher.replaceAll(this.dest);
            if (this.debugEnabled) {
                log.debug((Object)("Content with replacements performed:\n" + s));
            }
            if (!this.searchOnly) {
                FileUtils.writeTextFile((String)file.getPath(), (String)s);
            }
        } else if (this.debugEnabled) {
            log.debug((Object)("Sequence not found in file '" + file + "'"));
        }
    }

    public static void main(String ... args) {
        try {
            String rootFolder = args[0];
            String find = args[1];
            String replace = args[2];
            String ext = args[3];
            boolean searchOnly = Boolean.valueOf(args[4]);
            FileReplacer replacer = new FileReplacer();
            replacer.replace(rootFolder, find, replace, ext, searchOnly);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ReplacerFilter
    implements FileFilter {
        private String[] extensions = null;

        public ReplacerFilter(String ext) {
            if (ext == null) {
                ext = "";
            }
            this.extensions = ext.split(",");
            int i = 0;
            while (i < this.extensions.length) {
                this.extensions[i] = this.extensions[i].trim();
                ++i;
            }
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String ext = FileUtils.getFileExtension((File)file);
            if (ext == null) {
                return false;
            }
            String[] stringArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (ext.equalsIgnoreCase(s)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

