/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionHelper {
    private static Log log = LogFactory.getLog(ReflectionHelper.class);
    private boolean debugEnabled = log.isDebugEnabled();

    public static Object invokeMethod(Class<?> clazz, Object instance, String methodName, Class<?>[] paramTypes, Object ... values) {
        try {
            Method m = clazz.getMethod(methodName, paramTypes);
            return m.invoke(instance, values);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object invokeMethod(Class clazz, Object instance, String methodName, Object ... values) {
        try {
            Method[] methods;
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals(methodName)) {
                    return m.invoke(instance, values);
                }
                ++n2;
            }
            throw new NoSuchMethodException("class : " + clazz + ", method: " + methodName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object invokeMethod(Class clazz, Object instance, String methodName) {
        return ReflectionHelper.invokeMethod(clazz, instance, methodName, null, null);
    }

    public static Object newInstance(String className) {
        try {
            Class<?> c = ReflectionHelper.getCurrentClassLoader().loadClass(className);
            return c.newInstance();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object invokeConstructor(Class<?> clazz, Class<?>[] paramTypes, Object ... values) {
        try {
            Constructor<?> c = clazz.getConstructor(paramTypes);
            return c.newInstance(values);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object getField(Class clazz, Object instance, String fieldName) {
        try {
            Field f = clazz.getField(fieldName);
            return f.get(instance);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Class[] getClasses(String ... classNames) {
        try {
            if (classNames == null || classNames.length <= 0) {
                return new Class[0];
            }
            Class[] classes = new Class[classNames.length];
            ClassLoader cl = ReflectionHelper.getCurrentClassLoader();
            int i = 0;
            while (i < classNames.length) {
                classes[i] = cl.loadClass(classNames[i]);
                ++i;
            }
            return classes;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Class getClass0(String className) {
        try {
            return ReflectionHelper.getCurrentClassLoader().loadClass(className);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ReflectionHelper.class.getClassLoader();
        }
        return cl;
    }
}

