/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jppf.server.protocol.JPPFRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static String dumpObject(Object o) {
        return ReflectionUtils.dumpObject(o, "\n");
    }

    public static String dumpObject(Object o, String separator) {
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getName()).append("@").append(Integer.toHexString(o.hashCode())).append(separator);
        Method[] methods = clazz.getMethods();
        Method getter = null;
        TreeMap<String, Object> attrMap = new TreeMap<String, Object>();
        int i = 0;
        while (i < methods.length) {
            if (ReflectionUtils.isGetter(methods[i])) {
                getter = methods[i];
                String attrName = null;
                attrName = getter.getName().substring(getter.getName().startsWith("get") ? 3 : 2);
                attrName = String.valueOf(attrName.substring(0, 1).toLowerCase()) + attrName.substring(1);
                Object value = null;
                try {
                    value = getter.invoke(o, null);
                    if (value == null) {
                        value = "null";
                    }
                }
                catch (Exception e) {
                    value = "*Error: " + e.getMessage() + "*";
                }
                attrMap.put(attrName, value);
            }
            ++i;
        }
        Iterator it = attrMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append((String)entry.getKey()).append("=").append(entry.getValue());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean isGetter(Method meth) {
        Class<?> type = meth.getReturnType();
        if (Void.TYPE.equals(type)) {
            return false;
        }
        if (!meth.getName().startsWith("get") && !meth.getName().startsWith("is")) {
            return false;
        }
        if (meth.getName().startsWith("is") && !Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
            return false;
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        return paramTypes == null || paramTypes.length <= 0;
    }

    public static boolean isSetter(Method meth) {
        Class<?> type = meth.getReturnType();
        if (!Void.TYPE.equals(type)) {
            return false;
        }
        if (!meth.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        return paramTypes != null && paramTypes.length == 1;
    }

    public static Method getGetter(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        Method getter = null;
        int i = 0;
        while (i < methods.length) {
            if (ReflectionUtils.isGetter(methods[i]) && name.equals(methods[i].getName())) {
                getter = methods[i];
                break;
            }
            ++i;
        }
        return getter;
    }

    public static Method getSetter(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        Method setter = null;
        int i = 0;
        while (i < methods.length) {
            if (ReflectionUtils.isSetter(methods[i]) && name.equals(methods[i].getName())) {
                setter = methods[i];
                break;
            }
            ++i;
        }
        return setter;
    }

    public static Method getGetterForAttribute(Class clazz, String attrName) {
        String basename = String.valueOf(attrName.substring(0, 1).toUpperCase()) + attrName.substring(1);
        Method method = ReflectionUtils.getGetter(clazz, "get" + basename);
        if (method == null) {
            method = ReflectionUtils.getGetter(clazz, "is" + basename);
        }
        return method;
    }

    public static Method getSetterForAttribute(Class clazz, String attrName) {
        String basename = String.valueOf(attrName.substring(0, 1).toUpperCase()) + attrName.substring(1);
        return ReflectionUtils.getSetter(clazz, "set" + basename);
    }

    public static Method[] getAllBeanMethods(Class clazz, boolean getters) {
        Method[] allMethods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method[] methodArray = allMethods = clazz.getMethods();
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method meth = methodArray[n2];
            if (getters && ReflectionUtils.isGetter(meth) || !getters && ReflectionUtils.isSetter(meth)) {
                methodList.add(meth);
            }
            ++n2;
        }
        return methodList.toArray(new Method[0]);
    }

    public static Object deepCopy(Object o) {
        return null;
    }

    public static boolean isJPPFAnnotated(Class<?> clazz) {
        return ReflectionUtils.getJPPFAnnotatedElement(clazz) != null;
    }

    public static AnnotatedElement getJPPFAnnotatedElement(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Executable[] executableArray = clazz.getDeclaredMethods();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = executableArray[n2];
            if (ReflectionUtils.isJPPFAnnotated(m)) {
                return m;
            }
            ++n2;
        }
        executableArray = clazz.getDeclaredConstructors();
        n = executableArray.length;
        n2 = 0;
        while (n2 < n) {
            Executable c = executableArray[n2];
            if (ReflectionUtils.isJPPFAnnotated(c)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isJPPFAnnotated(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        if (annotatedElement == null) {
            return false;
        }
        Annotation[] annotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (JPPFRunnable.class.equals(a.annotationType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Method getMatchingMethod(Class clazz, String name, Object[] args) {
        Method[] methods;
        Class[] argTypes = ReflectionUtils.createTypeArray(args);
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name) && ReflectionUtils.matchingTypes(argTypes, m.getParameterTypes())) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    public static Constructor getMatchingConstructor(Class clazz, Object[] args) {
        Constructor<?>[] constructors;
        Class[] argTypes = ReflectionUtils.createTypeArray(args);
        Constructor<?>[] constructorArray = constructors = clazz.getDeclaredConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            if (ReflectionUtils.matchingTypes(argTypes, c.getParameterTypes())) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean matchingTypes(Class<?>[] argTypes, Class<?>[] types) {
        if (argTypes.length != types.length) {
            return false;
        }
        int i = 0;
        while (i < types.length) {
            if (argTypes[i] != null) {
                Class c;
                Class clazz = c = types[i].isPrimitive() ? ReflectionUtils.mapPrimitveType(types[i]) : types[i];
                if (!c.isAssignableFrom(argTypes[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static Class mapPrimitveType(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        return type;
    }

    public static Class[] createTypeArray(Object[] args) {
        if (args == null || args.length == 0) {
            return new Class[0];
        }
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = args[i] != null ? args[i].getClass() : null;
            ++i;
        }
        return argTypes;
    }
}

