/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFCallable;
import org.jppf.utils.ObjectSerializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceProvider {
    private static Logger log = LoggerFactory.getLogger(ResourceProvider.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public byte[] getResourceAsBytes(String resName) {
        return this.getResourceAsBytes(resName, null);
    }

    public byte[] getResourceAsBytes(String resName, ClassLoader cl) {
        try {
            File file;
            InputStream is;
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if ((is = cl.getResourceAsStream(resName)) == null && (file = new File(resName)).exists()) {
                is = new BufferedInputStream(new FileInputStream(file));
            }
            if (is != null) {
                if (debugEnabled) {
                    log.debug("resource [" + resName + "] found");
                }
                return FileUtils.getInputStreamAsByte((InputStream)is);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (debugEnabled) {
            log.debug("resource [" + resName + "] not found");
        }
        return null;
    }

    public byte[] getResource(String resName) {
        return this.getResource(resName, null);
    }

    public byte[] getResource(String resName, ClassLoader cl) {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        InputStream is = null;
        try {
            File file;
            URL url = cl.getResource(resName);
            if (url != null) {
                is = url.openStream();
            }
            if (is == null && (file = new File(resName)).exists()) {
                is = new BufferedInputStream(new FileInputStream(file));
            }
            if (is != null) {
                if (debugEnabled) {
                    log.debug("resource [" + resName + "] found");
                }
                return FileUtils.getInputStreamAsByte((InputStream)is);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (debugEnabled) {
            log.debug("resource [" + resName + "] not found");
        }
        return null;
    }

    public byte[] computeCallable(byte[] serializedCallable) {
        JPPFCallable callable = null;
        ObjectSerializerImpl ser = new ObjectSerializerImpl();
        Exception result = null;
        try {
            callable = (JPPFCallable)ser.deserialize(serializedCallable);
            result = callable.call();
        }
        catch (Exception e) {
            result = e;
        }
        byte[] bytes = null;
        try {
            bytes = ser.serialize(result).getBuffer();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                bytes = ser.serialize(e).getBuffer();
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        return bytes;
    }

    public List<byte[]> getMultipleResourcesAsBytes(String name, ClassLoader cl) {
        ArrayList<byte[]> result = null;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            Enumeration<URL> urlEnum = cl.getResources(name);
            if (urlEnum.hasMoreElements()) {
                result = new ArrayList<byte[]>();
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    InputStream is = url.openStream();
                    byte[] b = FileUtils.getInputStreamAsByte((InputStream)is);
                    result.add(b);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

