/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.taskwrapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.jppf.client.taskwrapper.AbstractPrivilegedAction;
import org.jppf.client.taskwrapper.AbstractTaskObjectWrapper;
import org.jppf.client.taskwrapper.PrivilegedConstructorAction;
import org.jppf.client.taskwrapper.PrivilegedMethodAction;
import org.jppf.client.taskwrapper.TaskObjectWrapper;
import org.jppf.utils.ReflectionUtils;

public class PojoTaskWrapper
extends AbstractTaskObjectWrapper {
    private Object taskObject = null;
    private String method = null;
    private Object[] args = null;
    private String className = null;

    public PojoTaskWrapper(String method, Object taskObject, Object ... args) {
        this.method = method;
        if (taskObject instanceof Class) {
            Class clazz = (Class)taskObject;
            this.methodType = method.equals(clazz.getSimpleName()) ? TaskObjectWrapper.MethodType.CONSTRUCTOR : TaskObjectWrapper.MethodType.STATIC;
            this.className = clazz.getName();
        } else {
            this.taskObject = taskObject;
            this.methodType = TaskObjectWrapper.MethodType.INSTANCE;
        }
        this.args = args;
    }

    @Override
    public Object execute() throws Exception {
        Class<?> clazz = TaskObjectWrapper.MethodType.INSTANCE.equals((Object)this.methodType) ? this.taskObject.getClass() : Class.forName(this.className);
        Object result = null;
        AbstractPrivilegedAction action = null;
        switch (this.methodType) {
            case INSTANCE: 
            case STATIC: {
                Method m = ReflectionUtils.getMatchingMethod(clazz, this.method, this.args);
                action = new PrivilegedMethodAction(m, this.taskObject, this.args);
                break;
            }
            case CONSTRUCTOR: {
                Constructor c = ReflectionUtils.getMatchingConstructor(clazz, this.args);
                action = new PrivilegedConstructorAction(c, this.args);
            }
        }
        result = AccessController.doPrivileged(action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return result;
    }

    @Override
    public Object getTaskObject() {
        return this.taskObject;
    }
}

