/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.doc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jppf.doc.JPPFDirFilter;
import org.jppf.doc.JPPFFileFilter;
import org.jppf.doc.ParameterNames;

public class ParametersHandler {
    public Map<ParameterNames, Object> parseArguments(String ... args) throws Exception {
        if (args == null || args.length < 3) {
            throw new IllegalArgumentException("not enough arguments there must be at least the 3 arguments: -s sourceDir -d destDir -t templatesDir");
        }
        HashMap<ParameterNames, Object> map = new HashMap<ParameterNames, Object>();
        int i = 0;
        while (i < args.length) {
            String cmd;
            if (!(cmd = args[i++]).startsWith("-")) {
                throw new IllegalArgumentException("unknown option '" + cmd + "', all options must start with '-'");
            }
            if ("-s".equals(cmd)) {
                map.put(ParameterNames.SOURCE_DIR, args[i++]);
                continue;
            }
            if ("-d".equals(cmd)) {
                map.put(ParameterNames.DEST_DIR, args[i++]);
                continue;
            }
            if ("-t".equals(cmd)) {
                map.put(ParameterNames.TEMPLATES_DIR, args[i++]);
                continue;
            }
            if ("-fi".equals(cmd)) {
                map.put(ParameterNames.FILE_INCLUDES, this.parseCommaSeparatedNames(args[i++]));
                continue;
            }
            if ("-fe".equals(cmd)) {
                map.put(ParameterNames.FILE_EXCLUDES, this.parseCommaSeparatedNames(args[i++]));
                continue;
            }
            if ("-di".equals(cmd)) {
                map.put(ParameterNames.DIR_INCLUDES, this.parseCommaSeparatedNames(args[i++]));
                continue;
            }
            if ("-de".equals(cmd)) {
                map.put(ParameterNames.DIR_EXCLUDES, this.parseCommaSeparatedNames(args[i++]));
                continue;
            }
            if ("-r".equals(cmd)) {
                map.put(ParameterNames.RECURSIVE, true);
                continue;
            }
            throw new IllegalArgumentException("unknown option '" + cmd + "'");
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (map.get((Object)ParameterNames.SOURCE_DIR) == null) {
            errors.add("missing option '-s sourceDir'");
        }
        if (map.get((Object)ParameterNames.DEST_DIR) == null) {
            errors.add("missing option '-d destDir'");
        }
        if (map.get((Object)ParameterNames.TEMPLATES_DIR) == null) {
            errors.add("missing option '-t templatesDir'");
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder("command-line errors:");
            for (String s : errors) {
                sb.append("\n  ").append(s);
            }
            throw new IllegalArgumentException(sb.toString());
        }
        if (map.get((Object)ParameterNames.RECURSIVE) == null) {
            map.put(ParameterNames.RECURSIVE, false);
        }
        if (map.get((Object)ParameterNames.FILE_INCLUDES) == null) {
            map.put(ParameterNames.FILE_INCLUDES, JPPFFileFilter.DEFAULT_INCLUDES);
        }
        if (map.get((Object)ParameterNames.DIR_EXCLUDES) == null) {
            map.put(ParameterNames.DIR_EXCLUDES, JPPFDirFilter.DEFAULT_EXCLUDES);
        }
        return map;
    }

    private String[] parseCommaSeparatedNames(String source) {
        if (source == null) {
            return null;
        }
        String[] result = source.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }
}

