/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.doc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jppf.JPPFException;
import org.jppf.doc.JPPFDirFilter;
import org.jppf.utils.FileUtils;

public class SamplesPHPReadmeProcessor
implements Runnable {
    private static final String START_CONTENT_TAG = "<!-- ${SAMPLE_START_CONTENT} -->";
    private static final String END_CONTENT_TAG = "<!-- ${SAMPLE_END_CONTENT} -->";
    private File sourceDir = null;
    private File destDir = null;
    private String template = null;

    public SamplesPHPReadmeProcessor(File sourceDir, File destDir, File template) throws Exception {
        this.sourceDir = sourceDir;
        this.destDir = destDir;
        this.template = FileUtils.readTextFile((File)template);
    }

    private List<File> getHTMLFiles() throws Exception {
        File[] subdirs;
        ArrayList<File> result = new ArrayList<File>();
        for (File dir : subdirs = this.sourceDir.listFiles(new JPPFDirFilter())) {
            File readme = new File(dir, "Readme.html");
            if (!readme.exists()) continue;
            result.add(readme);
        }
        return result;
    }

    @Override
    public void run() {
        try {
            List<File> list = this.getHTMLFiles();
            for (File file : list) {
                this.processFile(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processFile(File file) throws Exception {
        System.out.println("processing input file " + file);
        String text = FileUtils.readTextFile((File)file);
        int idx = text.indexOf("<h1>");
        if (idx < 0) {
            throw new JPPFException("could not find start of title for " + file);
        }
        int idx2 = text.indexOf("</h1>");
        if (idx2 < 0) {
            throw new JPPFException("could not find end of title for " + file);
        }
        String title = text.substring(idx + 4, idx2);
        idx = text.indexOf(START_CONTENT_TAG);
        if (idx < 0) {
            throw new JPPFException("could not find start of content for " + file);
        }
        idx2 = text.indexOf(END_CONTENT_TAG);
        if (idx2 < 0) {
            throw new JPPFException("could not find end of content for " + file);
        }
        String content = text.substring(idx + START_CONTENT_TAG.length(), idx2);
        String result = this.template.replace("${TITLE}", title);
        result = result.replace("${SAMPLE_README}", content);
        int len = this.sourceDir.getCanonicalPath().length();
        String s = file.getParentFile().getCanonicalPath().substring(len);
        if (s.startsWith("/") || s.startsWith("\\")) {
            s = s.substring(1);
        }
        s = s + "/Readme.php";
        File outFile = new File(this.destDir, s);
        boolean b = outFile.getParentFile().mkdirs();
        FileUtils.writeTextFile((File)outFile, (String)result);
        System.out.println("writing output file " + outFile);
    }

    public static void main(String[] args) {
        try {
            File srcDir = new File(args[0]);
            File destDir = new File(args[1]);
            File template = new File(args[2]);
            new SamplesPHPReadmeProcessor(srcDir, destDir, template).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

