/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer = null;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this(buffer, false);
    }

    public ByteBufferInputStream(ByteBuffer buffer, boolean flip) {
        this.buffer = buffer;
        if (flip) {
            buffer.flip();
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        if (len > this.buffer.remaining()) {
            len = this.buffer.remaining();
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        int pos = this.buffer.position();
        int newPos = (long)pos + n > (long)this.buffer.limit() ? this.buffer.limit() : pos + (int)n;
        this.buffer.position(newPos);
        return newPos - pos;
    }
}

