/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jppf.io.InputSource;
import org.jppf.utils.SerializationUtils;

public class ChannelInputSource
implements InputSource {
    protected ReadableByteChannel channel = null;
    protected ByteBuffer tmpDirectBuffer = null;

    public ChannelInputSource(ReadableByteChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, len);
        return this.read(buffer);
    }

    @Override
    public int read(ByteBuffer data) throws Exception {
        int count;
        int n;
        if (this.tmpDirectBuffer == null) {
            this.tmpDirectBuffer = ByteBuffer.allocateDirect(32768);
        } else {
            this.tmpDirectBuffer.clear();
        }
        int remaining = data.remaining();
        for (count = 0; count < remaining; count += n) {
            if (data.remaining() < this.tmpDirectBuffer.remaining()) {
                this.tmpDirectBuffer.limit(data.remaining());
            }
            if ((n = this.channel.read(this.tmpDirectBuffer)) < 0) {
                throw new EOFException();
            }
            if (n == 0) break;
            this.tmpDirectBuffer.flip();
            data.put(this.tmpDirectBuffer);
            this.tmpDirectBuffer.clear();
        }
        return count;
    }

    @Override
    public int readInt() throws Exception {
        return SerializationUtils.readInt((ReadableByteChannel)this.channel);
    }

    @Override
    public int skip(int n) throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(n);
        this.read(buf);
        return buf.position();
    }

    @Override
    public void close() throws IOException {
    }
}

