/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.data.transform.JPPFDataTransform;
import org.jppf.data.transform.JPPFDataTransformFactory;
import org.jppf.io.DataLocation;
import org.jppf.io.FileDataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.MultipleBuffersLocation;
import org.jppf.io.SocketWrapperInputSource;
import org.jppf.io.SocketWrapperOutputDestination;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.MultipleBuffersInputStream;
import org.jppf.utils.MultipleBuffersOutputStream;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOHelper {
    private static Logger log = LoggerFactory.getLogger(IOHelper.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    public static final int TEMP_BUFFER_SIZE = 32768;
    private static final double FREE_MEM_TO_SIZE_RATIO = JPPFConfiguration.getProperties().getDouble("jppf.disk.overflow.threshold", 2.0);

    private IOHelper() {
    }

    public static DataLocation createDataLocationMemorySensitive(int size) throws Exception {
        block3: {
            if (IOHelper.fitsInMemory(size)) {
                try {
                    return new MultipleBuffersLocation(size);
                }
                catch (OutOfMemoryError oome) {
                    if (!debugEnabled) break block3;
                    log.debug("OOM when allocating in-memory data location", (Throwable)oome);
                }
            }
        }
        File file = IOHelper.createTempFile(size);
        return new FileDataLocation(file, size);
    }

    public static DataLocation readData(InputSource source) throws Exception {
        int n = source.readInt();
        if (traceEnabled) {
            log.trace("read data size = " + n);
        }
        DataLocation dl = IOHelper.createDataLocationMemorySensitive(n);
        dl.transferFrom(source, true);
        return dl;
    }

    public static File createTempFile(int size) throws Exception {
        File file = File.createTempFile("jppf", ".tmp");
        if (debugEnabled) {
            log.debug("disk overflow: creating temp file '" + file.getCanonicalPath() + "' with size=" + size);
        }
        file.deleteOnExit();
        return file;
    }

    public static boolean fitsInMemory(int size) {
        long freeMem = SystemUtils.maxFreeHeap();
        if (traceEnabled) {
            log.trace("free mem / requested size : " + freeMem + "/" + size);
        }
        return (long)(FREE_MEM_TO_SIZE_RATIO * (double)size) < freeMem;
    }

    public static Object unwrappedData(SocketWrapper socketWrapper, ObjectSerializer ser) throws Exception {
        if (traceEnabled) {
            log.trace("unwrapping from network connection");
        }
        SocketWrapperInputSource sis = new SocketWrapperInputSource(socketWrapper);
        DataLocation dl = IOHelper.readData(sis);
        return IOHelper.unwrappedData(dl, ser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unwrappedData(DataLocation dl, ObjectSerializer ser) throws Exception {
        if (traceEnabled) {
            log.trace("unwrapping " + dl);
        }
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        File file = null;
        InputStream is = null;
        try {
            is = transform != null ? (IOHelper.fitsInMemory(dl.getSize()) ? IOHelper.unwrapData(transform, dl) : IOHelper.unwrapDataToFile(transform, dl)) : dl.getInputStream();
            Object object = ser.deserialize(is);
            return object;
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    public static InputStream unwrapData(JPPFDataTransform transform, DataLocation source) throws Exception {
        if (traceEnabled) {
            log.trace("unwrapping to memory " + source);
        }
        MultipleBuffersOutputStream mbos = new MultipleBuffersOutputStream();
        transform.unwrap(source.getInputStream(), (OutputStream)mbos);
        return new MultipleBuffersInputStream(mbos.toBufferList());
    }

    public static InputStream unwrapDataToFile(JPPFDataTransform transform, DataLocation source) throws Exception {
        if (traceEnabled) {
            log.trace("unwrapping to file " + source);
        }
        File file = IOHelper.createTempFile(-1);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        transform.unwrap(source.getInputStream(), (OutputStream)os);
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static void sendData(SocketWrapper socketWrapper, Object o, ObjectSerializer ser) throws Exception {
        DataLocation dl = null;
        if (traceEnabled) {
            log.trace("sending object " + o);
        }
        try {
            dl = IOHelper.serializeDataToMemory(o, ser);
        }
        catch (OutOfMemoryError e) {
            dl = IOHelper.serializeDataToFile(o, ser);
        }
        socketWrapper.writeInt(dl.getSize());
        SocketWrapperOutputDestination od = new SocketWrapperOutputDestination(socketWrapper);
        dl.transferTo(od, true);
    }

    public static DataLocation serializeData(Object o, ObjectSerializer ser) throws Exception {
        if (traceEnabled) {
            log.trace("serializing object " + o);
        }
        DataLocation dl = null;
        try {
            dl = IOHelper.serializeDataToMemory(o, ser);
        }
        catch (OutOfMemoryError e) {
            dl = IOHelper.serializeDataToFile(o, ser);
        }
        return dl;
    }

    public static DataLocation serializeDataToMemory(Object o, ObjectSerializer ser) throws Exception {
        if (traceEnabled) {
            log.trace("serializing object to memory " + o);
        }
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        MultipleBuffersOutputStream mbos = new MultipleBuffersOutputStream();
        ser.serialize(o, (OutputStream)mbos);
        if (transform != null) {
            MultipleBuffersInputStream mbis = new MultipleBuffersInputStream(mbos.toBufferList());
            mbos = new MultipleBuffersOutputStream();
            transform.wrap((InputStream)mbis, (OutputStream)mbos);
        }
        return new MultipleBuffersLocation(mbos.toBufferList(), mbos.size());
    }

    public static DataLocation serializeDataToFile(Object o, ObjectSerializer ser) throws Exception {
        if (traceEnabled) {
            log.trace("serializing object to file " + o);
        }
        File file = IOHelper.createTempFile(-1);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        ser.serialize(o, (OutputStream)os);
        FileDataLocation dl = null;
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        if (transform != null) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            File file2 = IOHelper.createTempFile(-1);
            os = new BufferedOutputStream(new FileOutputStream(file2));
            transform.wrap((InputStream)is, (OutputStream)os);
            dl = new FileDataLocation(file2);
        } else {
            dl = new FileDataLocation(file);
        }
        return dl;
    }
}

