/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jppf.io.AbstractDataLocation;
import org.jppf.io.DataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.OutputDestination;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.MultipleBuffersInputStream;
import org.jppf.utils.MultipleBuffersOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleBuffersLocation
extends AbstractDataLocation {
    private static Logger log = LoggerFactory.getLogger(MultipleBuffersLocation.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private List<JPPFBuffer> list = null;
    private int count = 0;
    private JPPFBuffer currentBuffer = null;
    private int currentBufferIndex = 0;

    public MultipleBuffersLocation(int size) {
        this.list = new ArrayList<JPPFBuffer>();
        this.list.add(new JPPFBuffer(new byte[size], size));
        this.size = size;
    }

    public MultipleBuffersLocation(List<JPPFBuffer> list, int size) {
        this.list = list;
        this.size = size;
    }

    public MultipleBuffersLocation(JPPFBuffer buffer) {
        this.list = new ArrayList<JPPFBuffer>();
        this.list.add(buffer);
        this.size = buffer.length;
    }

    @Override
    public int transferFrom(InputSource source, boolean blocking) throws Exception {
        if (!this.transferring) {
            this.transferring = true;
            this.currentBuffer = this.list.get(0);
            this.currentBufferIndex = 0;
            this.currentBuffer.pos = 0;
            if (!blocking) {
                this.list.clear();
                this.list.add(this.currentBuffer);
            }
            this.count = 0;
        }
        try {
            int n;
            int n2 = n = blocking ? this.blockingTransferFrom(source) : this.nonBlockingTransferFrom(source);
            if (n < 0 || this.count >= this.size) {
                this.transferring = false;
            }
            return n;
        }
        catch (Exception e) {
            this.transferring = false;
            throw e;
        }
    }

    private int blockingTransferFrom(InputSource source) throws Exception {
        while (this.count < this.size) {
            int remaining = this.size - this.count;
            int n = source.read(this.currentBuffer.buffer, this.currentBuffer.pos, remaining);
            if (n < 0) {
                throw new EOFException();
            }
            if (n < remaining) {
                this.currentBuffer.pos += n;
            }
            this.count += n;
        }
        this.transferring = false;
        return this.count;
    }

    private int nonBlockingTransferFrom(InputSource source) throws Exception {
        int remaining = this.size - this.count;
        int n = source.read(this.currentBuffer.buffer, this.currentBuffer.pos, remaining);
        if (n > 0) {
            this.count += n;
            this.currentBuffer.pos += n;
        }
        if (n < 0 || this.count >= this.size) {
            this.transferring = false;
        }
        return n;
    }

    @Override
    public int transferTo(OutputDestination dest, boolean blocking) throws Exception {
        if (!this.transferring) {
            this.transferring = true;
            if (!blocking) {
                this.currentBuffer = this.list.get(0);
                this.currentBuffer.pos = 0;
                this.currentBufferIndex = 0;
            }
            this.count = 0;
        }
        try {
            int n;
            int n2 = n = blocking ? this.blockingTransferTo(dest) : this.nonBlockingTransferTo(dest);
            if (n < 0 || this.count >= this.size) {
                this.transferring = false;
            }
            return n;
        }
        catch (Exception e) {
            this.transferring = false;
            throw e;
        }
    }

    private int blockingTransferTo(OutputDestination dest) throws Exception {
        this.count = 0;
        for (JPPFBuffer buf : this.list) {
            int remaining;
            int n;
            buf.pos = 0;
            for (int nbRead = 0; nbRead < buf.length && (n = dest.write(buf.buffer, buf.pos, remaining = buf.remainingFromPos())) > 0; nbRead += n) {
                if (n < remaining) {
                    buf.pos += n;
                }
                this.count += n;
            }
        }
        return this.count;
    }

    private int nonBlockingTransferTo(OutputDestination dest) throws Exception {
        if (this.currentBuffer == null) {
            return -1;
        }
        int remaining = this.currentBuffer.remainingFromPos();
        int n = dest.write(this.currentBuffer.buffer, this.currentBuffer.pos, remaining);
        if (traceEnabled) {
            log.trace("count/size=" + this.count + "/" + this.size + ", n/remaining=" + n + "/" + remaining + ", currentBufferIndex/listSize=" + this.currentBufferIndex + "/" + this.list.size() + ", pos=" + this.currentBuffer.pos + " (" + this + ")");
        }
        if (n > 0) {
            this.count += n;
        }
        if (n < remaining) {
            this.currentBuffer.pos += n;
        } else if (this.currentBufferIndex < this.list.size() - 1) {
            ++this.currentBufferIndex;
            this.currentBuffer = this.list.get(this.currentBufferIndex);
            this.currentBuffer.pos = 0;
        } else {
            this.currentBuffer = null;
        }
        return n;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return new MultipleBuffersInputStream(this.list);
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        return new MultipleBuffersOutputStream(this.list);
    }

    @Override
    public DataLocation copy() {
        ArrayList<JPPFBuffer> copyList = new ArrayList<JPPFBuffer>();
        for (JPPFBuffer buf : this.list) {
            copyList.add(new JPPFBuffer(buf.buffer, buf.length));
        }
        return new MultipleBuffersLocation(copyList, this.size);
    }
}

