/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.io.InputSource;

public class SocketWrapperInputSource
implements InputSource {
    private SocketWrapper socketWrapper = null;

    public SocketWrapperInputSource(SocketWrapper socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws Exception {
        int n = this.socketWrapper.read(data, offset, len);
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public int read(ByteBuffer data) throws Exception {
        byte[] buf = new byte[32768];
        int size = Math.min(buf.length, data.remaining());
        int n = this.read(buf, 0, size);
        if (n > 0) {
            data.put(buf, 0, n);
        }
        return n;
    }

    @Override
    public int readInt() throws Exception {
        return this.socketWrapper.readInt();
    }

    @Override
    public int skip(int n) throws Exception {
        return this.socketWrapper.skip(n);
    }

    @Override
    public void close() throws IOException {
    }
}

