/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jppf.scripting.JPPFScriptingException;
import org.jppf.scripting.ScriptRunner;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoScriptRunner
implements ScriptRunner {
    private static Logger log = LoggerFactory.getLogger(RhinoScriptRunner.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Context context = null;
    private Scriptable scope = null;
    private ErrorHandler errorHandler = new ErrorHandler();
    private static Map<String, Script> scriptMap = new HashMap<String, Script>();

    @Override
    public Object evaluate(String script, Map<String, Object> variables) throws JPPFScriptingException {
        return this.evaluate(null, script, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(String scriptId, String script, Map<String, Object> variables) throws JPPFScriptingException {
        this.init();
        this.errorHandler.errors.clear();
        Object result = null;
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            Object wrapped = Context.javaToJS((Object)entry.getValue(), (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)entry.getKey(), (Object)wrapped);
        }
        Script rhinoScript = null;
        if (scriptId != null) {
            rhinoScript = scriptMap.get(scriptId);
        }
        if (rhinoScript == null) {
            rhinoScript = this.context.compileString(script, "script", 1, null);
            if (scriptId != null) {
                scriptMap.put(scriptId, rhinoScript);
            }
        }
        try {
            result = rhinoScript.exec(this.context, this.scope);
        }
        catch (EvaluatorException e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            for (String name : variables.keySet()) {
                ScriptableObject.deleteProperty((Scriptable)this.scope, (String)name);
            }
            this.cleanup();
        }
        if (!this.errorHandler.errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : this.errorHandler.errors) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            sb.insert(0, "Errors occurred while executing the script:\n");
            throw new JPPFScriptingException(sb.toString());
        }
        return result;
    }

    @Override
    public void init() {
        this.context = new ContextFactory().enterContext();
        this.scope = new ImporterTopLevel(this.context);
        this.context.setErrorReporter((ErrorReporter)this.errorHandler);
    }

    @Override
    public void cleanup() {
        Context.exit();
    }

    public static class ErrorHandler
    implements ErrorReporter {
        public List<String> errors = new ArrayList<String>();

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.errors.add(this.makeErrorString(message, sourceName, line, lineSource, lineOffset));
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            String s = this.makeErrorString(message, sourceName, line, lineSource, lineOffset);
            this.errors.add(s);
            return new EvaluatorException(s);
        }

        private String makeErrorString(String message, String sourceName, int line, String lineSource, int lineOffset) {
            StringBuilder sb = new StringBuilder();
            sb.append(message).append(" at ").append(line).append(":").append(lineOffset).append(":\n");
            sb.append("Source = ").append(lineSource);
            return sb.toString();
        }
    }
}

